#include "CS_ShutterBig.h"

CS_ShutterBig::CS_ShutterBig()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_shutter_big";
	cbRect.left = 16;
	cbRect.top = 16;
	cbRect.right = 16;
	cbRect.bottom = 16;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
}

void CS_ShutterBig::Init(std::weak_ptr<Entity> self)
{
	x += 0x1000 / ts;
	y += 0x1000 / ts;
	last_x = x;
	last_y = y;
	srcX = x;
	srcY = y;
	Entity::Init(self);
}

void CS_ShutterBig::Step()
{
	switch (stateID)
	{
	case 0:
		vx = vy = 0;
		break;
	case 1://
		vy = -moveSpeed;
		MoveEffect();
		break;
	case 2://
		vy = moveSpeed;
		MoveEffect();
		break;
	case 3://
		vx = -moveSpeed;
		MoveEffect();
		break;
	case 4://
		vx = moveSpeed;
		MoveEffect();
		break;
	}
	//ִ˶
	Entity::Step();
}

void CS_ShutterBig::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal" || stateName == L"stop")
	{
		stateID = 0;
	}
	else if (stateName == L"up")
	{
		stateID = 1;
	}
	else if (stateName == L"down")
	{
		stateID = 2;
	}
	else if (stateName == L"left")
	{
		stateID = 3;
	}
	else if (stateName == L"right")
	{
		stateID = 4;
	}
	else if (stateName == L"up_immed")
	{
		y -= 32;
	}
	else if (stateName == L"down_immed")
	{
		y += 32;
	}
	else if (stateName == L"left_immed")
	{
		x -= 32;
	}
	else if (stateName == L"right_immed")
	{
		x += 32;
	}
	else if (stateName == L"reset_pos")
	{
		x = srcX;
		y = srcY;
	}
}

void CS_ShutterBig::MoveEffect()
{
	if (++move_counter % 8 == 0)
		gameFunc->PlaySound(L"CS_026_quake");
	if (gameFunc->SetQuake)
		gameFunc->SetQuake(gameFunc->game, 20, 0);
}

std::shared_ptr<Entity> CreateCS_ShutterBig()
{
	return std::make_shared<CS_ShutterBig>();
}
