#include "CS_ShockWaveBase.h"
#include "CS_ShockWave.h"
CS_ShockWaveBase::CS_ShockWaveBase()
{
	action_timecounter = action_timecounter_max = 8;
}

void CS_ShockWaveBase::Step()
{
	if (lr != 0)
	{
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			action_timecounter = action_timecounter_max;
			auto e = std::make_shared<CS_ShockWave>();
			e->x = x - 16;
			e->y = y;
			gameFunc->SetEntity(shared_from_this(), e);
		}
	}
}

std::shared_ptr<Entity> CreateCS_ShockWaveBase()
{
	return std::make_shared<CS_ShockWaveBase>();
}
