#pragma once
#include "Entity.h"
#include "EntityState.h"
#include "EntityStateFlashEffect.h"
#include "EntityStateInvincible.h"
#include "CS_QuoteGravity.h"
#include "CS_SantaWater.h"
#include "CS_SantaDrown.h"
#include "CS_SantaControl.h"
#include "CS_SantaResist.h"
#include "CS_SantaJump.h"
#include "CS_SantaStand.h"
#include "CS_SantaMove.h"
#include "CS_SantaAir.h"
#include "CS_SantaFaceToBack.h"
#include "CS_SantaHurt.h"
#include "CS_SantaFireball.h"
#include "CS_SantaGhostFire.h"
#define CS_SANTA_CREATENAME L"CS_mychar_santa"
//ҽɫ ɣ
class CS_Santa :
	public MyCharEntity
{
public:
	CS_Santa();
	void Init(std::weak_ptr<Entity> self) override;
	void Step() override;
	void SetState(int stateID, int lr) override;
	void SetState(std::wstring stateName, int lr) override;
	void LoadSaveData() override;//ر
	void WriteSaveData() override;//д뱣
	bool Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage) override;
	void Gain(std::weak_ptr<Entity> item) override;
	void Destroy() override;
	void GetIcon(std::wstring& png, std::wstring& sprite_index, int& image_index, std::set<int>& hideLayerList) override;
	void CrushDeath();
	void GetAnimateOffset(float& outDx, float& outDy) override;//ȡƫ
	std::weak_ptr<Entity> BeginCaught(std::weak_ptr<Entity> e) override;//ʼĳλץȡлץȡ״̬Ĳ
	//ͼʾ
	bool showGun = false;//ʾǹ
	float animation_moveSpeed = 0x200 / ts;
	bool animation_delay = false;//·ӳһ֡뵽
	//״̬ģ
	EntityStateFlashEffect stateFlash;
	EntityStateInvincible stateInvincible;
	CS_QuoteGravity stateGravity;
	CS_SantaWater stateWater;
	CS_SantaDrown stateDrown;
	CS_SantaControl stateControl;
	CS_SantaResist stateResist;
	CS_SantaJump stateJump;
	CS_SantaStand stateStand;
	CS_SantaMove stateMove;
	CS_SantaAir stateAir;
	CS_SantaFaceToBack stateFaceToBack;
	CS_SantaHurt stateHurt;
	//ģ
	CS_SantaFireball skillFireball;
	CS_SantaGhostFire skillGhostFire;
	//
	std::wstring crushEvent;
private:
	void AnimateStep();//
};

std::shared_ptr<Entity> CreateCS_Santa();