#include "CS_SakamotoSueAni.h"

CS_SakamotoSueAni::CS_SakamotoSueAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
}

void CS_SakamotoSueAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	Entity::Init(self);
}

void CS_SakamotoSueAni::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	switch (stateID)
	{
	case 0://վ
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_SakamotoSueAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	//ö
	switch (stateID)
	{
	case 0://վ
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_sakamotosue_stand_l" : L"mc_sakamotosue_stand_r";
		break;
	case 1://·
		{
			animation_delay = true;
			if (lr == 0)
				vx = -animation_moveSpeed;
			else
				vx = animation_moveSpeed;
			ani.sprite_index = lr == 0 ? L"mc_sakamotosue_move_l" : L"mc_sakamotosue_move_r";
		}
		break;
	case 3://
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_sakamotosue_angry_l" : L"mc_sakamotosue_angry_r";
		break;
	}
}

void CS_SakamotoSueAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"angry")
	{
		ani.image_index = 0;
		ani.image_counter = 0;
		SetState(3, lr);
	}
}

std::shared_ptr<Entity> CreateCS_SakamotoSueAni()
{
	return std::make_shared<CS_SakamotoSueAni>();
}
