#include "CS_QuoteSuperMissileBlade.h"
#include "CS_Quote.h"
#include "CS_PeGunShotSpark.h"
#include "CS_PeGunShotHit.h"
#include "CS_PeHurt.h"
#include "CS_PeBooster.h"
#include "CS_QuoteSuperMissileBladeExplode.h"
CS_QuoteSuperMissileBlade::CS_QuoteSuperMissileBlade(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//÷ͳʼλ
	ud = parent->ud;
	lr = parent->lr;
	if (ud == -1)
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y - 8;
		ani.sprite_index = L"am_supermissile_u";
		SetCS_PeGunShotSpark(parent, x, y);
	}
	else if (ud == 0)
	{
		y = parent->y + 3;
		if (lr == 0)
		{
			x = parent->x - 6;
			ani.sprite_index = L"am_supermissile_l";
			SetCS_PeGunShotSpark(parent, parent->x - 0x1800 / ts, y);
		}
		else
		{
			x = parent->x + 6;
			ani.sprite_index = L"am_supermissile_r";
			SetCS_PeGunShotSpark(parent, parent->x + 0x1800 / ts, y);
		}
	}
	else
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y + 8;
		ani.sprite_index = L"am_supermissile_d";
		SetCS_PeGunShotSpark(parent, x, y);
	}
	//ʱ
	action_timecounter_max = 40;
	action_timecounter = action_timecounter_max;
}

void CS_QuoteSuperMissileBlade::Init(std::weak_ptr<Entity> self)
{
	tgt_x = x;
	tgt_y = y;
	//ڷɵٶ
	static unsigned int inc;
	switch (++inc % 3)
	{
	case 0:
		ani_no = 0x200;
		break;
	case 1:
		ani_no = 0x100;
		break;
	case 2:
		ani_no = 0xAA;
		break;
	}
	//
	if (ud == 0)
	{
		auto wattackParent = attackParent.lock();
		if (wattackParent)
			vy = y > wattackParent->y ? 0x100 / ts : -0x100 / ts;
		vx = Random(-0x200, 0x200) / ts;
	}
	else
	{
		auto wattackParent = attackParent.lock();
		if (wattackParent)
			vx = x > wattackParent->x ? 0x100 / ts : -0x100 / ts;
		vy = Random(-0x200, 0x200) / ts;
	}
		
	ActionEntity::Init(self);
}

void CS_QuoteSuperMissileBlade::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ
	if (ani.png.length() == 0)
		ani.png = L"CS_CaveStoryMod";
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ǽײ
	SetCbRect_Collision();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
	//ʵײ
	SetCbRect_Entity();
	//ʧ
	if (action_timecounter > 0)
	{
		action_timecounter--;
		if (action_timecounter == 0)
		{
			SetCS_PeGunShotSpark(shared_from_this(), x, y);
			Destroy();
		}
	}
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if ((ud == 0 && (cbRect.cbLeft || cbRect.cbRight)) ||
		(ud != 0 && (cbRect.cbTop || cbRect.cbBottom)))
	{
		Explode();
	}
	//
	if (ud == 0)
	{
		if (cbRect.cbTop)
			vy = abs(vy);
		else if (cbRect.cbBottom)
			vy = -abs(vy);
	}
	else
	{
		if (cbRect.cbLeft)
			vx = abs(vx);
		else if (cbRect.cbRight)
			vx = -abs(vx);
	}
	//
	if (ud == 0)
		vx += (lr == 0 ? -ani_no / ts : ani_no / ts);
	else
		vy += (ud == -1 ? -ani_no / ts : ani_no / ts);
	//°ڶ
	if (ud == 0)
		vy += (y < tgt_y ? 0x40 / ts : -0x40 / ts);
	else
		vx += (x < tgt_x ? 0x40 / ts : -0x40 / ts);
	//ٶ
	if (vx < -0x1400 / ts)
		vx = -0x1400 / ts;
	if (vx > 0x1400 / ts)
		vx = 0x1400 / ts;
	if (vy < -0x1400 / ts)
		vy = -0x1400 / ts;
	if (vy > 0x1400 / ts)
		vy = 0x1400 / ts;
	//Ч
	if (++count2 > 2)
	{
		count2 = 0;
		float dx = 0;
		float dy = 0;
		if (ud == 0)
			dx = lr == 0 ? 8.0f : -8.0f;
		else
			dy = ud == -1 ? 8.0f : -8.0f;
		auto pe = std::make_shared<CS_PeBooster>(lr, ud);
		pe->x = x + dx;
		pe->y = y + dy;
		gameFunc->SetEntity(shared_from_this(), pe);
	}
}

void CS_QuoteSuperMissileBlade::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage == 0)
	{
		gameFunc->PlaySound(L"CS_031_shot_bounce");
		SetCS_PeGunShotHit(shared_from_this(), centerX, centerY);
	}
	else
	{
		auto wtarget = target.lock();
		if (wtarget)
		{
			if (wtarget->hp > 0)
				SetCS_PeHurt_Num3(shared_from_this(), centerX, centerY);
		}
	}
}

bool CS_QuoteSuperMissileBlade::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	*outRealDamage = getDamage;
	if (getDamage > 0)
	{
		Explode();
		return true;
	}
	return false;
}

void CS_QuoteSuperMissileBlade::Destroy()
{
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		auto mychar = std::static_pointer_cast<CS_Quote>(wattackParent);
		auto& amList = mychar->skillSuperMissile.amList;
		for (auto iter = amList.begin(); iter != amList.end(); iter++)
		{
			if ((*iter).lock() == shared_from_this())
			{
				amList.erase(iter);
				break;
			}
		}
	}
	ActionEntity::Destroy();
}

void CS_QuoteSuperMissileBlade::Collision()
{
	Entity::Collision();
}

void CS_QuoteSuperMissileBlade::SetCbRect_Entity()
{
	cbRect.left = 4;
	cbRect.right = 4;
	cbRect.top = 4;
	cbRect.bottom = 4;
	cbRect.breakStarBlock = false;
}

void CS_QuoteSuperMissileBlade::SetCbRect_Collision()
{
	cbRect.left = 2;
	cbRect.right = 2;
	cbRect.top = 2;
	cbRect.bottom = 2;
	cbRect.breakStarBlock = true;
}

void CS_QuoteSuperMissileBlade::Explode()
{
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		auto am = std::make_shared<CS_QuoteSuperMissileBladeExplode>(wattackParent);
		am->x = x;
		am->y = y;
		gameFunc->SetEntity(shared_from_this(), am);
	}
	Destroy();
}

std::weak_ptr<CS_QuoteSuperMissileBlade> SetCS_QuoteSuperMissileBlade(std::shared_ptr<Entity> parent, float x, float y)
{
	auto am = std::make_shared<CS_QuoteSuperMissileBlade>(parent);
	am->x = x;
	am->y = y;
	parent->gameFunc->SetEntity(parent, am);
	return am;
}
