#include "CS_QuoteMove.h"
#include "CS_Quote.h"
const int CS_QuoteSTATENAME_MOVE = ++entityStateID;
CS_QuoteMove::CS_QuoteMove()
{
	stateID = CS_QuoteSTATENAME_MOVE;
}

void CS_QuoteMove::State()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Quote>(we);
	if (mychar->fishState)
	{
		const wchar_t* move = L"";
		if (we->ud == -1)
			move = we->lr == 0 ? L"mc_quotefish_swim_lu" : L"mc_quotefish_swim_ru";
		else if (we->ud == 0)
			move = we->lr == 0 ? L"mc_quotefish_swim_l" : L"mc_quotefish_swim_r";
		else if (we->ud == 1)
			move = we->lr == 0 ? L"mc_quotefish_swim_ld" : L"mc_quotefish_swim_rd";
		we->ani.sprite_index = move;
	}
	else
	{
		const wchar_t* move = L"";
		if (we->ud == -1)
			move = we->lr == 0 ? L"mc_quote_move_lu" : L"mc_quote_move_ru";
		else if (we->ud == 0)
			move = we->lr == 0 ? L"mc_quote_move_l" : L"mc_quote_move_r";
		else if (we->ud == 1)
			move = we->lr == 0 ? L"mc_quote_move_ld" : L"mc_quote_move_rd";
		we->ani.sprite_index = move;
		if ((we->ani.image_index == 1 || we->ani.image_index == 3) && playWalkSound)
		{
			we->gameFunc->PlaySound(L"CS_024_quote_walk");
			playWalkSound = false;
		}
		if (we->ani.image_index == 0 || we->ani.image_index == 2)
			playWalkSound = true;
	}
}

void CS_QuoteMove::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
		enable = true;
	else
		enable = false;
}
