#include "CS_QuoteBoosterDash.h"
#include "CS_PeHurt.h"

CS_QuoteBoosterDash::CS_QuoteBoosterDash(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	x = parent->x;
	y = parent->y;
	//÷ͳʼλ
	ud = parent->ud;
	lr = parent->lr;
	//Χ
	cbRect.left = parent->cbRect.left + 4;
	cbRect.right = parent->cbRect.right + 4;
	cbRect.top = parent->cbRect.top + 4;
	cbRect.bottom = parent->cbRect.bottom + 4;
	if (ud == 0)
	{
		if (lr == 0)
			cbRect.left += 4;
		else
			cbRect.right += 4;
	}
	else
	{
		if (ud == -1)
			cbRect.top += 4;
		else
			cbRect.bottom += 4;
	}
}

void CS_QuoteBoosterDash::Init(std::weak_ptr<Entity> self)
{
	//Ч
	auto wlightTail = std::make_shared<PeLightTail>(shared_from_this(), 40, ud == 0 ? (cbRect.top + cbRect.bottom) : (cbRect.left + cbRect.right));
	lightTail = wlightTail;
	wlightTail->SetColor(0xff, 0, 0);
	wlightTail->SetAlphaDiv(2.0f);
	gameFunc->SetEntity(shared_from_this(), wlightTail);
	Entity::Init(self);
}

void CS_QuoteBoosterDash::Step()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
	{
		Destroy();
		return;
	}
	x = wattackParent->x;
	last_x = wattackParent->last_x;
	y = wattackParent->y;
	last_y = wattackParent->last_y;
}

void CS_QuoteBoosterDash::Destroy()
{
	auto wlightTail = lightTail.lock();
	if (wlightTail)
		wlightTail->Leave();
	Entity::Destroy();
}

void CS_QuoteBoosterDash::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 15;
	if (lr == 0)
	{
		*outAngle = 270;
	}
	else
	{
		*outAngle = 270;
	}
	*outTakedown = false;
	*outElemType = 0;
	*outShockForce = 0 / ts;
	*outHeavy = 0;
}

void CS_QuoteBoosterDash::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	auto wtarget = target.lock();
	if (wtarget)
	{
		if (wtarget->hp > 0)
			SetCS_PeHurt_Num3(shared_from_this(), centerX, centerY);
	}
}
