#include "CS_QuoteBooster.h"
#include "CS_Quote.h"
#include "CS_PeBooster.h"
const int CS_QuoteSTATENAME_BOOSTER = ++entityStateID;
CS_QuoteBooster::CS_QuoteBooster()
{
	enable = true;
	SetPhysice(false);
	stateID = CS_QuoteSTATENAME_BOOSTER;
}

void CS_QuoteBooster::State()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Quote>(we);
	if (mychar->fishState)
	{
		if (inBoost)
			QuitBoost();
	}
	else
	{
		//ڿ˵״̬
		if ((mychar->stateJump.jumped || !we->cbRect.cbBottom) &&
			!mychar->stateJump.jump_disable &&
			!inBoost &&
			fuel_counter > 0 &&
			mychar->input.GetJump())
		{
			float boostSpeed = 0x5ff / ts;
			if (we->cbRect.inWater)
				boostSpeed /= 2.0f;
			if (mychar->input.GetUp())
			{
				boostDir = 0;
				we->vx = 0;
				we->vy = -boostSpeed;
			}
			else if (mychar->input.GetRight())
			{
				boostDir = 1;
				we->vy = 0;
				we->vx = boostSpeed;
			}
			else if (mychar->input.GetDown())
			{
				boostDir = 2;
				we->vx = 0;
				we->vy = boostSpeed;
			}
			else if (mychar->input.GetLeft())
			{
				boostDir = 3;
				we->vy = 0;
				we->vx = -boostSpeed;
			}
			else
			{
				boostDir = 0;
				we->vx = 0;
				we->vy = -boostSpeed;
			}
			inBoost = true;
			mychar->stateGravity.SetEnable(false);
			//ʱ޵
			mychar->stateInvincible.eternalInvincible = true;
			mychar->stateInvincible.EnableFlash(false);
			mychar->color = RGBA(0xff, 0xff, 0xff, 0x80);
			auto wblade = dashAtk.lock();
			if (wblade)
				wblade->Destroy();
			wblade = std::make_shared<CS_QuoteBoosterDash>(we);
			dashAtk = wblade;
			we->gameFunc->SetEntity(we, wblade);
		}
		bool outOfFuel = fuel_counter == 0;
		if (inBoost && fuel_counter > 0)
		{
			//Եǽ
			if ((boostDir == 1 || boostDir == 3) && (we->cbRect.cbLeft || we->cbRect.cbRight))
				we->vy = -0x100 / ts;
			if (we->input.GetLeft() && we->vx > -mychar->stateControl.max_move)
				we->vx -= mychar->stateControl.move2;
			if (we->input.GetRight() && we->vx < mychar->stateControl.max_move)
				we->vx += mychar->stateControl.move2;
			mychar->stateJump.jumped = true;
			fuel_counter--;
			if (fuel_counter == 0)
				outOfFuel = true;
			//Ч
			if (fuel_counter % 3 == 1)
			{
				if ((boostDir == 1 || boostDir == 3))
				{
					if (we->input.GetLeft())
						boostDir = 3;
					else if (we->input.GetRight())
						boostDir = 1;
				}
				we->gameFunc->PlaySound(L"CS_113");
				float dx = 0;
				float dy = 0;
				switch (boostDir)
				{
				case 0:
					dy = 6;
					break;
				case 1://
					dx = -2;
					dy = 2;
					break;
				case 2:
					dy = -6;
					break;
				case 3://
					dx = 2;
					dy = 2;
					break;
				}
				auto pe = std::make_shared<CS_PeBooster>(boostDir);
				pe->x = we->x + dx;
				pe->y = we->y + dy;
				we->gameFunc->SetEntity(we, pe);
			}
		}
		else
		{
			if (mychar->cbRect.cbBottom)
			{
				fuel_counter = fuel_counter_max;
			}
		}
		//˳ƽ״̬
		if (inBoost && (!mychar->input.GetJump() || outOfFuel))
			QuitBoost();
	}
	//ȼ
	fcounter = fuel_counter / (float)fuel_counter_max;
	if (fuel_counter < fuel_counter_max)
	{
		if (fuelBar.expired())
		{
			auto wfuelBar = std::make_shared<PeReadyBar>(mychar, &fcounter, RGBA(0, 0xb5, 0, 0xff), 0, -20,
				&CS_QuoteBooster::ReadyBar_Leave,
				&CS_QuoteBooster::ReadyBar_Destroy);
			fuelBar = wfuelBar;
			we->gameFunc->SetEntity(we, wfuelBar);
		}
	}
	//ɫ仯
	if (!fuelBar.expired())
	{
		auto wfuelBar = fuelBar.lock();
		wfuelBar->color = fuel_counter == 0 ? RGBA(0xb5, 0, 0, 0xff) : RGBA(0, 0xb5, 0, 0xff);
	}
}

void CS_QuoteBooster::SetPhysice(bool bInWater)
{
	auto we = e.lock();
	if (!we)
		return;

	//ˢٶ״̬
	if (inBoost && we->cbRect.inWater != lastInWater)
	{
		lastInWater = we->cbRect.inWater;
		float boostSpeed = 0x5ff / ts;
		if (we->cbRect.inWater)
			boostSpeed /= 2.0f;
		switch (boostDir)
		{
		default:
		case 0:
			we->vy = -boostSpeed;
			break;
		case 1:
			we->vx = boostSpeed;
			break;
		case 2:
			we->vy = boostSpeed;
			break;
		case 3:
			we->vx = -boostSpeed;
			break;
		}
	}
}

bool CS_QuoteBooster::ReadyBar_Leave(std::weak_ptr<Entity> e)
{
	auto we = e.lock();
	if (!we)
		return true;

	auto mychar = std::static_pointer_cast<CS_Quote>(we);
	auto& stateBooster = mychar->stateBooster;
	bool bLeave = stateBooster.fuel_counter == stateBooster.fuel_counter_max;
	if (bLeave)
		stateBooster.fuelBar.reset();
	return bLeave;
}

void CS_QuoteBooster::ReadyBar_Destroy(std::weak_ptr<Entity> e)
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Quote>(we);
	auto& stateBooster = mychar->stateBooster;
	stateBooster.fuelBar.reset();
}

void CS_QuoteBooster::QuitBoost()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Quote>(we);
	//ٶ½
	switch (boostDir)
	{
	case 0:
		we->vy /= 2.0f;
		break;
	case 1:
	case 3:
		we->vx /= 2.0f;
		break;
	}
	inBoost = false;
	mychar->stateGravity.SetEnable(true);
	boostDir = 0;
	//˳޵
	mychar->stateInvincible.eternalInvincible = false;
	mychar->stateInvincible.EnableFlash(true);
	mychar->color = RGBA(0xff, 0xff, 0xff, 0xff);
	mychar->stateJump.jump_disable = true;//ֹٴ

	auto wblade = dashAtk.lock();
	if (wblade)
		wblade->Destroy();
}

