#include "CS_PuppySitting.h"

CS_PuppySitting::CS_PuppySitting()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 4;
	cbRect.top = 8;
	cbRect.bottom = 8;
}

void CS_PuppySitting::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		ani_no = 0;
		ani_wait = 0;
		//bits |= NPC_INTERACTABLE;
		[[fallthrough]];
	case 1:
		if (Random(0, 120) == 10)
		{
			act_no = 2;
			act_wait = 0;
			ani_no = 1;
		}
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (x - 64 < wplayer->x && x + 64 > wplayer->x && y - 32 < wplayer->y && y + 16 > wplayer->y)
				{
					if (++ani_wait > 3)
					{
						ani_wait = 0;
						++ani_no;
					}

					if (ani_no > 3)
						ani_no = 2;
				}
				if (x - 96 < wplayer->x && x + 96 > wplayer->x && y - 32 < wplayer->y && y + 16 > wplayer->y)
				{
					if (x > wplayer->x)
						lr = 0;
					else
						lr = 1;
				}
			}
		}
		break;
	case 2:
		if (++act_wait > 8)
		{
			act_no = 1;
			ani_no = 0;
		}
		break;
	}
	ani.sprite_index = lr == 0 ? L"ls_puppy_sitting_l" : L"ls_puppy_sitting_r";
}

void CS_PuppySitting::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->act_no = stateID;
	ani.sprite_index = lr == 0 ? L"ls_puppy_sitting_l" : L"ls_puppy_sitting_r";
}

std::shared_ptr<Entity> CreateCS_PuppySitting()
{
	return std::make_shared<CS_PuppySitting>();
}
