#include "CS_PuppyFishHurt.h"
const int CS_PuppyFishSTATENAME_HURT = ++entityStateID;
CS_PuppyFishHurt::CS_PuppyFishHurt()
{
	stateID = CS_PuppyFishSTATENAME_HURT;
}

void CS_PuppyFishHurt::State()
{
	auto we = e.lock();
	if (!we)
		return;

	we->ani.sprite_index = we->lr == 0 ? L"mc_puppyfish_hurt_l" : L"mc_puppyfish_hurt_r";
}

void CS_PuppyFishHurt::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
	{
		auto we = e.lock();
		if (!we)
			return;

		auto mychar = std::static_pointer_cast<MyCharEntity>(we);
		enable = true;
		mychar->action_timecounter = 30;
	}
	else
		enable = false;
}
