#include "CS_PuppyCarried.h"
#include "CS_PuppyBarkMark.h"
#include "CS_MyCharAi.h"
CS_PuppyCarried::CS_PuppyCarried()
{
	ani.png = L"CS_CaveStoryMod";
	drawBeforeOtherEntity = true;
}

CS_PuppyCarried::~CS_PuppyCarried()
{
	auto wicon = aiIcon.lock();
	if (wicon)
	{
		auto mycharAI_Icon = std::dynamic_pointer_cast<CS_MyCharAi_Icon>(wicon);
		if (mycharAI_Icon)
		{
			mycharAI_Icon->dx = 0;
			mycharAI_Icon->dy = 0;
		}
	}
}

void CS_PuppyCarried::Step()
{
	GridTouch();
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		ani_no = 0;
		ani_wait = 0;
		[[fallthrough]];
	case 1:
		if (Random(0, 120) == 10)
		{
			act_no = 2;
			act_wait = 0;
			ani_no = 1;
		}
		{
			bool b = false;
			//Ǻŷͽ
			for (auto& e : touchList)
			{
				auto we = e.lock();
				if (we)
				{
					if (we->el.name == CS_PUPPYBARKMARK_CREATENAME ||
						we->el.arg2 == L"realDoor")
					{
						b = true;
						if (++ani_wait > 4)
						{
							ani_wait = 0;
							++ani_no;
						}
						if (ani_no > 4)
							ani_no = 2;
						if (ani_no == 4 && ani_wait == 0)
							gameFunc->PlaySound(L"CS_105_puppy_bark");
					}
				}
			}
			if (!b)
			{
				if (ani_no == 4)
					ani_no = 2;
			}
		}
		break;
	case 2:
		if (++act_wait > 8)
		{
			act_no = 1;
			ani_no = 0;
		}
		break;
	}
	if (!gameFunc->GetGlobalEntityTable)
		return;
	if (el.arg.empty())
		return;

	auto wtarget = target.lock();
	if (wtarget && wtarget->hide)
		target.reset();
	wtarget = target.lock();
	if(!wtarget)
	{
		//ѰҸٶ
		//ٶ
		bool bFound = false;
		auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
		for (auto& p : allPlayer)
		{
			auto wplayer = p.second.lock();
			if (wplayer)
			{
				if (wplayer->hide)
					continue;
				if (wplayer->ani.sprite_index.find(el.arg) != std::wstring::npos)
				{
					//ʹ
					bFound = true;
					target = wplayer;
					break;
				}
			}
		}
		//ڳʵбѰ
		if (!bFound)
		{
			for (auto& we : entityLayer->Ls)
			{
				if (we->hide)
					continue;
				if (we->ani.sprite_index.find(el.arg) != std::wstring::npos)
				{
					//ʹ
					bFound = true;
					target = we;
					break;
				}
			}
		}
		if (!bFound)
			ani.sprite_index = L"";
	}
	wtarget = target.lock();
	if (wtarget)
	{
		float dx = 0, dy = 0;
		wtarget->GetAnimateOffset(dx, dy);
		//
		lr = wtarget->lr;
		if (lr == 0)
		{
			x = wtarget->x + 0x800 / ts + dx;
			last_x = wtarget->last_x + 0x800 / ts + dx;
		}
		else
		{
			x = wtarget->x - 0x800 / ts + dx;
			last_x = wtarget->last_x - 0x800 / ts + dx;
		}
		y = wtarget->y - 0x1400 / ts + dy;
		last_y = wtarget->last_y - 0x1400 / ts + dy;
		ani.sprite_index = lr == 0 ? L"ls_puppy_carried_l" : L"ls_puppy_carried_r";
		//ĿAIƵ
		//AIʾͼλ
		auto wtarget = target.lock();
		if (wtarget)
		{
			auto wai = wtarget->ai.lock();
			if (wai)
			{
				auto wmychar_ai = std::dynamic_pointer_cast<CS_MyCharAi>(wai);
				if (wmychar_ai)
				{
					aiIcon = wmychar_ai->icon;
					auto wicon = wmychar_ai->icon.lock();
					if (wicon)
					{
						wicon->dx = 0;
						wicon->dy = -10;
					}
				}
			}
		}
	}
	else
	{
		//
		auto wicon = aiIcon.lock();
		if (wicon)
		{
			auto mycharAI_Icon = std::dynamic_pointer_cast<CS_MyCharAi_Icon>(wicon);
			if (mycharAI_Icon)
			{
				mycharAI_Icon->dx = 0;
				mycharAI_Icon->dy = 0;
			}
		}
	}
}

void CS_PuppyCarried::SetState(int stateID, int lr)
{
	this->lr = lr;
}

std::shared_ptr<Entity> CreateCS_PuppyCarried()
{
	return std::make_shared<CS_PuppyCarried>();
}
