#include "CS_PuppyBite.h"
#include "CS_Puppy.h"
#include "CS_PuppyBiteBlade.h"
const int CS_PUPPYSTATENAME_BITE = ++entityStateID;
CS_PuppyBite::CS_PuppyBite()
{
	stateID = CS_PUPPYSTATENAME_BITE;
	cd_counter = 0;
	cd_counter_max = 30;
	iconIndex = 0;
}

const wchar_t* CS_PuppyBite::GetSaveName()
{
	return L"Bite";
}

void CS_PuppyBite::State()
{
	//ܿ
	auto we = e.lock();
	if (!we)
		return;
	auto mychar = std::static_pointer_cast<CS_Puppy>(we);
	if (ready_counter < ready_counter_max)
	{
		ready_counter++;
		mychar->ani.sprite_index = mychar->lr == 0 ? L"mc_puppy_charge_l" : L"mc_puppy_charge_r";
		if (ready_counter >= ready_counter_max)
		{
			mychar->vy = -0x400 / ts;
			mychar->vx = mychar->lr == 0 ? -0x800 / ts : 0x800 / ts;
			//
			auto am = std::make_shared<CS_PuppyBiteBlade>(mychar);
			am->x = mychar->x;
			am->y = mychar->y;
			mychar->gameFunc->SetEntity(mychar, am);
		}
		return;
	}
	mychar->ani.sprite_index = mychar->lr == 0 ? L"mc_puppy_bite_l" : L"mc_puppy_bite_r";
	if (mychar->cbRect.cbBottom)
	{
		mychar->action_timecounter = 0;
	}
}

void CS_PuppyBite::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Puppy>(we);
	bool a1 = mychar->cbRect.cbBottom &&
		!mychar->InAction() &&
		!lock;
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = cd_counter == 0 && mychar->mp >= mp_cost;

	bool a = a1;
	bool b = b1;
	bool c = c1;
	if (a && b && c)
	{
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//ȴʱ
	if (!mychar->InAction())
	{
		if (cd_counter > 0)
			cd_counter--;
	}
	//ҪUI
}

void CS_PuppyBite::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
	{
		//ʼ
		auto we = e.lock();
		if (!we)
			return;
		auto mychar = std::static_pointer_cast<CS_Puppy>(we);
		enable = true;
		//
		cd_counter = cd_counter_max;
		mychar->action_timecounter = mychar->action_timecounter_max;
		//׼
		mychar->vx = 0;
		ready_counter = 0;
	}
	else
		enable = false;
}

bool CS_PuppyBite::Hurt(std::weak_ptr<Entity> src, int* pGetDamage, float* pAngle, bool* pTakedown, int* pElemType, float* pShockForce, float* pHeavy, int* outRealDamage, bool* outRetVal)
{
	auto we = e.lock();
	if (!we)
		return false;

	if (enable)
	{
		//һɹ޵״̬
		*outRetVal = false;
		return true;
	}

	return false;
}

bool CS_PuppyBite::BeginCaught(std::weak_ptr<Entity> src, std::weak_ptr<Entity>& ret)
{
	if (enable)
	{
		//
		ret = std::weak_ptr<Entity>();//ᱻ
		return true;
	}
	else
	{
		//
		return false;
	}
}
