#include "CS_PlayerLight.h"

CS_PlayerLight::CS_PlayerLight(int playerIndex)
{
	this->playerIndex = playerIndex;
	//
	light.usingLight = true;
	//ͼ
	ani.png = L"light_fade";
	ani.sprite_index = L"r4x4";
}

void CS_PlayerLight::Step()
{
	if (!(gameFunc && gameFunc->GetMyChar_Player1))
		return;
	std::weak_ptr<Entity> target;
	if (playerIndex == 0)
		target = gameFunc->GetMyChar_Player1(gameFunc->entityRes);
	else
		target = gameFunc->GetMyChar_Player2(gameFunc->entityRes);
	auto wtarget = target.lock();
	if (wtarget)
	{
		x = wtarget->x;
		last_x = wtarget->last_x;
		y = wtarget->y;
		last_y = wtarget->last_y;
		if(wtarget->hide || wtarget->el.name == L"null")
		{
			ani.png = L"";
		}
		else
		{
			ani.png = L"light_fade";
		}
	}
	else
	{
		ani.png = L"";
	}
}

void CS_PlayerLight::SetRadius(int r)
{
	switch (r)
	{
	default:
	case 1:
		ani.sprite_index = L"r1x1";
		break;
	case 4:
		ani.sprite_index = L"r4x4";
		break;
	case 5:
		ani.sprite_index = L"r5x5";
		break;
	case 6:
		ani.sprite_index = L"r6x6";
		break;
	case 7:
		ani.sprite_index = L"r7x7";
		break;
	}
}
