#include "CS_PeFireworksSpark.h"

CS_PeFireworksSpark::CS_PeFireworksSpark()
{
	type = 3;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"pe_fireworks";
	ani.hideLayerList.insert(Random(0, 1));
	disappear_counter = disappear_counter_max;
}

void CS_PeFireworksSpark::Init(std::weak_ptr<Entity> self)
{
	//ù
	auto wpeLight = std::make_shared<CS_PeLightFade>();
	peLight = wpeLight;
	gameFunc->SetEntity(shared_from_this(), wpeLight);
	wpeLight->SetRadius(1);
	wpeLight->last_x = wpeLight->x = x;
	wpeLight->last_y = wpeLight->y = y;
	Entity::Init(self);
}

void CS_PeFireworksSpark::Step()
{
	if (exist_counter > 0)
	{
		exist_counter--;
		if (exist_counter == 0)
			bDisappear = true;//ɢ
	}
	if (bDisappear)
	{
		if (disappear_counter > 0)
		{
			disappear_counter--;
			if (disappear_counter == 0)
				Destroy();
		}
	}
	vy += 0x10 / ts;
	vx *= 0.9f;
	vy *= 0.9f;
	//ִ˶
	Entity::Step();
	//ͼ͵ƹ͸
	BYTE a = disappear_counter * 0xff / disappear_counter_max;
	color = RGBA(0xff, 0xff, 0xff, a);
	//
	auto wpeLight = peLight.lock();
	if (wpeLight)
	{
		wpeLight->x = x;
		wpeLight->last_x = last_x;
		wpeLight->y = y;
		wpeLight->last_y = last_y;
	}
}

void CS_PeFireworksSpark::Destroy()
{
	auto wpeLight = peLight.lock();
	if (wpeLight)
		wpeLight->Destroy();
	Entity::Destroy();
}

void CS_PeFireworksSpark::Shoot(float dir_x, float dir_y, float speed)
{
	vx = speed * dir_x;
	vy = speed * dir_y;
	//ñըʱ
	exist_counter = Random(20, 30);
}

void SetCS_PeFireworksSpark(std::shared_ptr<Entity> parent, float x, float y, float dir_x, float dir_y, float speed)
{
	auto pe = std::make_shared<CS_PeFireworksSpark>();
	pe->x = x;
	pe->y = y;
	pe->Shoot(dir_x, dir_y, speed);
	pe->ani.image_index = parent->ani.image_index;
	parent->gameFunc->SetEntity(parent, pe);
}
