#include "CS_PeCountdown.h"

CS_PeCountdown::CS_PeCountdown()
{
	type = 3;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"pe_countdown";
}

void CS_PeCountdown::Step()
{
	//ִ˶
	Entity::Step();
	switch (act_no)
	{
	case 0:
		act_no = 1;
		gameFunc->PlaySound(L"CS_043_computer_beep");
		[[fallthrough]];
	case 1:
		dx += 1;
		if (++act_wait > 8)
		{
			act_wait = 0;
			act_no = 2;
		}
		break;
	case 2:
		if (++act_wait > 30)
		{
			Destroy();
			return;
		}
		break;
	}
}

std::weak_ptr<CS_PeCountdown> SetCS_PeCountdown(std::shared_ptr<Entity> parent, float x, float y, int num)
{
	auto pe = std::make_shared<CS_PeCountdown>();
	pe->x = x;
	pe->y = y;
	pe->ani.image_index = num;
	parent->gameFunc->SetEntity(parent, pe);
	return pe;
}
