#include "CS_MonsterXScreen.h"
#include "CS_PeSmoke.h"

CS_MonsterXScreen::CS_MonsterXScreen()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_monsterx_screen";
	cbRect.left = 8;
	cbRect.right = 464 - 8;
	cbRect.top = 8;
	cbRect.bottom = 128 - 8;
	drawBeforeOtherEntity = true;
}

void CS_MonsterXScreen::Step()
{
	if (explodeCounter > 0)
	{
		if (explodeCounter % 8 == 0)
			gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
		explodeCounter--;
		SetCS_PeSmoke2(shared_from_this(), x, y);
		if (explodeCounter == 0)
		{
			gameFunc->PlaySound(L"CS_035_explosion1");
			Destroy();
		}
	}
}

void CS_MonsterXScreen::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.image_index = stateID;
}

void CS_MonsterXScreen::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"defeated")
	{
		attackState = false;
		explodeCounter = 100;
	}
}

std::shared_ptr<Entity> CreateCS_MonsterXScreen()
{
	return std::make_shared<CS_MonsterXScreen>();
}
