#include "CS_MonsterXAni.h"
#include "CS_PeSmoke.h"
CS_MonsterXAni::CS_MonsterXAni()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"mc_monsterx_stand_l";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 12;
	cbRect.top = 8;
	cbRect.bottom = 8;
	drawBeforeOtherEntity = true;
}

void CS_MonsterXAni::Step()
{

	switch (stateID)
	{
	case 0://˶
		ani.sprite_index = lr == 0 ? L"mc_monsterx_sit_l" : L"mc_monsterx_sit_r";
		WinkAnimate();//գ
		break;
	case 1://׹
		vy += 0x20 / ts;
		if (drop_counter > 0)
		{
			drop_counter--;
			cbRect.enableSoild = false;
		}
		else
		{
			cbRect.enableSoild = true;
		}
		if (cbRect.enableSoild)
		{
			if (cbRect.cbBottom)
			{
				for (int i = 0; i < 4; i++)
				{
					auto pe = std::make_shared<CS_PeSmoke>();
					pe->x = x + Random(-12, 12);
					pe->y = y + Random(-12, 12);
					pe->vx = Random(-341, 341) / ts;
					pe->vy = Random(-0x600, 0) / ts;
					gameFunc->SetEntity(shared_from_this(), pe);
				}
				//лվ״̬
				stateID = 2;
				gameFunc->PlaySound(L"CS_026_quake");
				if (gameFunc->SetQuake)
					gameFunc->SetQuake(gameFunc->game, 30, 0);
			}
		}
		//
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		if (vy < -0x5FF / ts)
			vy = -0x5FF / ts;
		ani.sprite_index = lr == 0 ? L"mc_monsterx_fall_l" : L"mc_monsterx_fall_r";
		break;
	case 2://վ˶
		ani.sprite_index = lr == 0 ? L"mc_monsterx_sit_l" : L"mc_monsterx_sit_r";
		WinkAnimate();//գ
		break;
	case 3://볡
		cbRect.enableSoild = false;
		vy -= 0x20 / ts;
		//
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		if (vy < -0x5FF / ts)
			vy = -0x5FF / ts;
		if (y < 0)
		{
			//лվ״̬
			cbRect.enableSoild = true;
			stateID = 2;
			gameFunc->PlaySound(L"CS_026_quake");
			if (gameFunc->SetQuake)
				gameFunc->SetQuake(gameFunc->game, 30, 0);
		}
		ani.sprite_index = lr == 0 ? L"mc_monsterx_leave_l" : L"mc_monsterx_leave_r";
		break;
	case 4://
		ani.sprite_index = lr == 0 ? L"mc_monsterx_back_l" : L"mc_monsterx_back_r";
		break;
	case 5://1
		ani.sprite_index = lr == 0 ? L"mc_monsterx_face1_l" : L"mc_monsterx_face1_r";
		break;
	case 6://2
		ani.sprite_index = lr == 0 ? L"mc_monsterx_face2_l" : L"mc_monsterx_face2_r";
		break;
	case 7://3
		ani.sprite_index = lr == 0 ? L"mc_monsterx_face3_l" : L"mc_monsterx_face3_r";
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_MonsterXAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	if (stateID < 1000)
	{
		this->stateID = stateID;
	}
	else
	{
		this->stateID = 1;
		drop_counter = stateID - 1000;
	}
}

void CS_MonsterXAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal" || stateName == L"sit")
		SetState(0, lr);
	if (stateName == L"back")
		SetState(4, lr);
	if (stateName == L"face1")
		SetState(5, lr);
	if (stateName == L"face2")
		SetState(6, lr);
	if (stateName == L"face3")
		SetState(7, lr);
}

void CS_MonsterXAni::SetFace(int face)
{
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(1);
	ani.hideLayerList.erase(face);
}

void CS_MonsterXAni::WinkAnimate()
{
	//գ
	if (Random(0, 120) == 10)
	{
		wink_counter = 8;
	}
	if (wink_counter > 0)
	{
		wink_counter--;
		SetFace(1);
	}
	else
	{
		SetFace(0);
	}
}

std::shared_ptr<Entity> CreateCS_MonsterXAni()
{
	return std::make_shared<CS_MonsterXAni>();
}
