#include "CS_MasroAni.h"
#include "CS_PeZzz.h"

CS_MasroAni::CS_MasroAni()
{
	ani.png = L"CS_CaveStoryMod";
}

void CS_MasroAni::Step()
{
	switch (stateID)
	{
	case 0://
		{
			auto& ani_no = ani.image_index;
			switch (act_no)
			{
			case 0:
				x += 0x800 / ts;
				y += 0x2000 / ts;
				act_no = 1;
				ani_no = 0;
				ani_wait = 0;
				[[fallthrough]];
			case 1:
				if (++ani_wait > 2)
				{
					ani_wait = 0;
					++ani_no;
				}
				if (ani_no > 1)
					ani_no = 0;
				if (Random(0, 80) == 1)
				{
					act_no = 2;
					act_wait = 0;
					ani_no = 1;
				}
				if (Random(0, 120) == 10)
				{
					act_no = 3;
					act_wait = 0;
					ani_no = 2;
				}
				break;
			case 2:
				if (++act_wait > 40)
				{
					act_no = 3;
					act_wait = 0;
					ani_no = 2;
				}
				break;
			case 3:
				if (++act_wait > 80)
				{
					act_no = 1;
					ani_no = 0;
				}
				break;
			}
		}
		break;
	case 1://˯
		if (++act_wait > 100)
		{
			act_wait = 0;
			SetPeCS_Zzz(shared_from_this(), x, y);
		}
		break;
	}
	
	//ִ˶
	Entity::Step();
}

void CS_MasroAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	switch (stateID)
	{
	case 0://
		ani.sprite_index = L"mc_masro_computer";
		break;
	case 1://˯
		y -= 6;
		x -= 9;
		vx = 0;
		vy = 0;
		ani.sprite_index = lr == 0 ? L"mc_masro_sleep_l" : L"mc_masro_sleep_r";
		break;
	}
}

void CS_MasroAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"computer")
		SetState(0, lr);
	if (stateName == L"sleep")
		SetState(1, lr);
}

std::shared_ptr<Entity> CreateCS_MasroAni()
{
	return std::make_shared<CS_MasroAni>();
}
