#include "CS_MalcoAni.h"
#include "CS_PeSmoke.h"
CS_MalcoAni::CS_MalcoAni()
{
	ani.png = L"CS_CaveStoryMod";
	drawBeforeOtherEntity = true;
}

void CS_MalcoAni::Step()
{
	auto& ani_no = ani.image_index;
	int i;
	//ִ˶
	Entity::Step();
	switch (act_no)
	{
	case 0:
		act_no = 1;
		break;
	case 10:
		act_no = 11;
		act_wait = 0;
		ani_wait = 0;
		for (i = 0; i < 4; ++i)
		{
			auto pe = std::make_shared<CS_PeSmoke>();
			pe->x = x;
			pe->y = y;
			pe->vx = Random(-341, 341) / ts;
			pe->vy = Random(-0x600, 0) / ts;
			gameFunc->SetEntity(shared_from_this(), pe);
		}
		[[fallthrough]];
	case 11:
		if (++ani_wait > 1)
		{
			gameFunc->PlaySound(L"CS_043_computer_beep");
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 1)
			ani_no = 0;
		if (++act_wait > 100)
			act_no = 12;
		break;
	case 12:
		act_no = 13;
		act_wait = 0;
		ani_no = 1;
		[[fallthrough]];
	case 13:
		if (++act_wait > 50)
			act_no = 14;
		break;
	case 14:
		act_no = 15;
		act_wait = 0;
		[[fallthrough]];
	case 15:
		if (act_wait / 2 % 2)
		{
			x += 0x200 / ts;
			gameFunc->PlaySound(L"CS_011_door");
		}
		else
		{
			x -= 0x200 / ts;
		}
		if (++act_wait > 50)
			act_no = 16;
		break;
	case 16:
		act_no = 17;
		act_wait = 0;
		ani_no = 2;
		gameFunc->PlaySound(L"CS_012_block_destroy");
		for (i = 0; i < 8; ++i)
		{
			auto pe = std::make_shared<CS_PeSmoke>();
			pe->x = x;
			pe->y = y;
			pe->vx = Random(-341, 341) / ts;
			pe->vy = Random(-0x600, 0) / ts;
			gameFunc->SetEntity(shared_from_this(), pe);
		}
		[[fallthrough]];
	case 17:
		if (++act_wait > 150)
			act_no = 18;
		break;
	case 18:
		act_no = 19;
		act_wait = 0;
		ani_no = 3;
		ani_wait = 0;
		[[fallthrough]];
	case 19:
		if (++ani_wait > 3)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 4)
		{
			gameFunc->PlaySound(L"CS_011_door");
			ani_no = 3;
		}
		if (++act_wait > 100)
		{
			act_no = 20;
			gameFunc->PlaySound(L"CS_012_block_destroy");
			for (i = 0; i < 4; ++i)
			{
				auto pe = std::make_shared<CS_PeSmoke>();
				pe->x = x;
				pe->y = y;
				pe->vx = Random(-341, 341) / ts;
				pe->vy = Random(-0x600, 0) / ts;
				gameFunc->SetEntity(shared_from_this(), pe);
			}
		}
		break;
	case 20:
		ani_no = 4;
		break;
	case 21:
		act_no = 22;
		ani_no = 5;
		gameFunc->PlaySound(L"CS_051_enemy_hurt");
		break;
	case 100:
		act_no = 101;
		ani_no = 6;
		ani_wait = 0;
		[[fallthrough]];
	case 101:
		if (++ani_wait > 4)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 9)
			ani_no = 6;
		break;
	case 110:
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		Destroy();
		[[fallthrough]];
	case 200:
		act_no = 201;
		action_timecounter = 60;
		ani.image_index = 5;
		break;
	case 201:
		ani.image_index = 5;
		if (action_timecounter > 0)
		{
			action_timecounter--;
			if (action_timecounter == 0)
			{
				gameFunc->PlaySound(L"CS_072_big_crash");
				//
				SetCS_PeSmokeLarge(shared_from_this(), x, y);
				Destroy();
			}
		}
		break;
	}
	ani.sprite_index = lr == 0 ? L"ls_malco_l" : L"ls_malco_r";
}

void CS_MalcoAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	act_no = stateID;
	ani.sprite_index = lr == 0 ? L"ls_malco_l" : L"ls_malco_r";
}

std::shared_ptr<Entity> CreateCS_MalcoAni()
{
	return std::make_shared<CS_MalcoAni>();
}
