#include "CS_MahinAni.h"
#include "CS_PeZzz.h"
#include <PeSmog.h>
CS_MahinAni::CS_MahinAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
}

void CS_MahinAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	Entity::Init(self);
}

void CS_MahinAni::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	switch (stateID)
	{
	case 0://վ
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		stateGravity.Step();
		break;
	case 1:
		stateGravity.Step();
		break;
	case 2://
		break;
	case 3://
		break;
	case 4://˯
		vx = 0;
		vy = 0;
		//zzz
		if (++act_wait > 100)
		{
			act_wait = 0;
			SetPeCS_Zzz(shared_from_this(), x, y);
		}
		break;
	case 5://
		break;
	case 6://
		vx = 0;
		vy = 0;
		break;
	case 7:
		if (abs(vx) > 0.001f)
			vx /= 1.1f;
		else
			vx = 0;
		break;
	case 9:
		vx = 0;
		vy = 0;
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_MahinAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	//ö
	switch (stateID)
	{
	case 0://վ
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_mahin_stand_l" : L"mc_mahin_stand_r";
		break;
	case 1://·
		{
			animation_delay = true;
			if (lr == 0)
				vx = -animation_moveSpeed;
			else
				vx = animation_moveSpeed;
			const wchar_t* move = L"";
			if (ud == -1)
				move = lr == 0 ? L"mc_mahin_move_lu" : L"mc_mahin_move_ru";
			else
				move = lr == 0 ? L"mc_mahin_move_l" : L"mc_mahin_move_r";
			ani.sprite_index = move;
		}
		break;
	case 2://
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_mahin_back_l" : L"mc_mahin_back_r";
		break;
	case 3://
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_mahin_lie_l" : L"mc_mahin_lie_r";
		break;
	case 4://˯
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_mahin_lie_l" : L"mc_mahin_lie_r";
		break;
	case 5://
		break;
	case 6://
		ani.sprite_index = lr == 0 ? L"mc_mahin_pluck_l" : L"mc_mahin_pluck_r";
		break;
	case 7://
		ani.sprite_index = lr == 0 ? L"mc_mahin_lie_l" : L"mc_mahin_lie_r";
		vx = lr == 0 ? -0x800 / ts : 0x800 / ts;
		gameFunc->PlaySound(L"CS_070_expl_small");
		SetPeSmog(shared_from_this(), x, y, 1, 1, 135);
		SetPeSmog(shared_from_this(), x, y, 1, 1, 45);
		break;
	case 8://
		ani.sprite_index = lr == 0 ? L"mc_mahin_sit_l" : L"mc_mahin_sit_r";
		break;
	case 9://
		vx = 0;
		y -= 3;
		ani.sprite_index = lr == 0 ? L"mc_mahin_sit_l" : L"mc_mahin_sit_r";
		break;
	}
}

void CS_MahinAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"back")
		SetState(2, lr);
	else if (stateName == L"on_table")
		y -= 6;
	else if (stateName == L"lie")
		SetState(3, lr);
	else if (stateName == L"sleep")
		SetState(4, lr);
	else if (stateName == L"cry")
	{
		ani.sprite_index = this->lr == 0 ? L"mc_mahin_cry_l" : L"mc_mahin_cry_r";
		ani.image_index = lr;
		stateID = 5;
	}
	else if (stateName == L"pluck")
		SetState(6, lr);
	else if (stateName == L"down")
		SetState(7, lr);
	else if (stateName == L"sit")
		SetState(8, lr);
	else if (stateName == L"sit_on_chair")
		SetState(9, lr);
	else if (stateName == L"drawBefore")
	{
		drawBeforeOtherEntity = true;
	}
}

std::shared_ptr<Entity> CreateCS_MahinAni()
{
	return std::make_shared<CS_MahinAni>();
}
