#include "CS_LargeDoor.h"

CS_LargeDoor::CS_LargeDoor()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_largedoor_closed";
	drawBeforeOtherEntity = true;
	cbRect.left = cbRect.right = 6;
}

void CS_LargeDoor::Step()
{
	switch (stateID)
	{
	case 0:
		break;
	case 1:
		if (++sound_counter % 8 == 0)
			gameFunc->PlaySound(L"CS_026_quake");
		if (ani.image_index == 12)
			SetState(2, lr);
		break;
	case 2:
		break;
	}
}

void CS_LargeDoor::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	shader.usingShader = false;
	switch (stateID)
	{
	case 0://رյ
		ani.sprite_index = L"ls_largedoor_closed";
		break;
	case 1://
		ani.sprite_index = L"ls_largedoor_opening";
		sound_counter = 0;
		ani.image_index = 0;
		shader.usingShader = true;//ʹüй
		break;
	case 2://򿪵
		ani.sprite_index = L"ls_largedoor_opened";
		break;
	}
	if (lr != 0)
		SetState(2, 0);
}

void CS_LargeDoor::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"close")
		SetState(0, lr);
	else if (stateName == L"opening")
		SetState(1, lr);
	else if (stateName == L"open")
		SetState(2, lr);
}

std::shared_ptr<Entity> CreateCS_LargeDoor()
{
	return std::make_shared<CS_LargeDoor>();
}
