#include "CS_KanpaGrapplingHookBlade.h"
#include "CS_Kanpa.h"
#include "PeSmog.h"
#include "CS_PeSmoke.h"
CS_KanpaGrapplingHookBlade::CS_KanpaGrapplingHookBlade(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ʼ
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"am_fishhook_270";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.fullWaterBlock = true;
	//ײ
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 4;
	damage_reset_counter = 30;
	attackState_reset_counter_max = 30;
	el.name = L"fishhook";
}

void CS_KanpaGrapplingHookBlade::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateGravity.SetGravityScale(0.5f);
	Entity::Init(self);
}

void CS_KanpaGrapplingHookBlade::Step()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return;

	auto mychar = std::static_pointer_cast<CS_Kanpa>(wattackParent);
	if (!bHooked)
	{
		//׵
		stateGravity.Step();
		//סĿ꣬Ŀֻǽ
		if (cbRect.cbTop && cbRect.movingPlatformTop.expired())
		{
			vx = 0;
			vy = 0;
			bHooked = true;
			//
			for (size_t i = 0; i < 3; i++)
			{
				float offset_x = (float)Random((int)-cbRect.left, (int)cbRect.right);
				float offset_y = (float)Random((int)-cbRect.top, (int)cbRect.bottom);
				auto e = std::make_shared<CS_PeSmoke>();
				e->x = x + offset_x;
				e->y = y + offset_y;
				gameFunc->SetEntity(shared_from_this(), e);
			}
			gameFunc->PlaySound(L"CS_012_block_destroy");
		}
		else if (vy > 0)
			Leave();
	}
	//뿪ҹ״̬
	if (!mychar->skillGrapplingHook.GetEnable())
		Leave();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	last_lineX = lineX;
	last_lineY = lineY;
	lineX = wattackParent->x - x;
	lineY = wattackParent->y - y;
}

void CS_KanpaGrapplingHookBlade::DeltaTime(float deltaTime)
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return;

	float nowPlayerX = lerp(last_lineX, lineX, deltaTime);
	float nowPlayerY = lerp(last_lineY, lineY, deltaTime);
	AddFillLine(fillList, 0, 1, 4, RGBA(0xff, 0xff, 0xff, 0xff), nowPlayerX, nowPlayerY - 18, RGBA(0xff, 0xff, 0xff, 0xff), 1);
	Entity::DeltaTime(deltaTime);
}

void CS_KanpaGrapplingHookBlade::Leave()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return;

	auto mychar = std::static_pointer_cast<CS_Kanpa>(wattackParent);
	auto pe = std::make_shared<PeSmog>();
	pe->x = x;
	pe->y = y;
	gameFunc->SetEntity(shared_from_this(), pe);
	mychar->skillGrapplingHook.QuitHook();
	Destroy();
}
