#include "CS_KanpaGrapplingHook.h"
#include "CS_Kanpa.h"
#include "CS_KanpaGrapplingHookBlade.h"
const int CS_KanpaSTATENAME_GRAPPLINGHOOK = ++entityStateID;
CS_KanpaGrapplingHook::CS_KanpaGrapplingHook()
{
	stateID = CS_KanpaSTATENAME_GRAPPLINGHOOK;
	cd_counter = 0;
	cd_counter_max = 30;
	iconIndex = 4;
}

const wchar_t* CS_KanpaGrapplingHook::GetSaveName()
{
	return L"GrapplingHook";
}

const wchar_t* CS_KanpaGrapplingHook::GetFuncName()
{
	return L"KanpaSkill_GrapplingHook";
}

const wchar_t* CS_KanpaGrapplingHook::GetCheckFuncName()
{
	return L"KanpaSkill_GrapplingHook_Check";
}

void CS_KanpaGrapplingHook::State()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Kanpa>(we);
	auto whook = hook.lock();
	//ȡ
	if (whook && mychar->input.key & keyMask)
	{
		whook->Leave();
		QuitHook();
	}
	//ػ
	mychar->stateControl.MoveControl();
	if (we->input.GetLeft())
		we->lr = 0;
	else if (we->input.GetRight())
		we->lr = 1;
	if (whook->bHooked)
	{
		//ˮƽٶԼm
		float dx = (we->x) - (whook->x + 1);
		float dy = (we->y - 18) - (whook->y + 4);
		auto angle = XMConvertToDegrees(XMVectorGetX(XMVector2AngleBetweenVectors(XMVectorSet(1, 0, 0, 0), XMVectorSet(dx, dy, 0, 0))));
		float dstAngle = angle - 90;
		mychar->vx += mychar->stateControl.move * sinf(dstAngle * deg2rad);
		mychar->vx /= 1.05f;
		if (mychar->y - 18 > whook->y + 4)
		{
			mychar->vy = 0;
			//ڼƶʽ
			if (we->input.GetUp())
				mychar->vy = -mychar->stateControl.move * cosf(dstAngle * deg2rad) * 4;
			else if (we->input.GetDown())
				mychar->vy = mychar->stateControl.move * cosf(dstAngle * deg2rad) * 4;
			if (we->input.GetJump())
			{
				//ҹ״̬Ծ
				mychar->stateJump.SetJump();
				whook->Leave();
				QuitHook();
			}
		}
	}
	//ö
	mychar->ani.sprite_index = we->lr == 0 ? L"mc_kanpa_hooked_l" : L"mc_kanpa_hooked_r";
}

void CS_KanpaGrapplingHook::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Kanpa>(we);
	bUIShowDisableSkill = !((
		!mychar->InAction()) &&
		!lock
		);

	bool a1 = !mychar->InAction() &&
		!lock;
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = cd_counter == 0;

	bool a = a1;
	bool b = b1;
	bool c = c1;
	//
	if (a && b && c)
	{
		mychar->faceToBack = false;
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//ȴʱ
	if (hook.expired())
	{
		//ζ
		if (a && b && !c)
		{
			we->shock_counter = 30;
			//ס
			mychar->inputLock.key |= keyMask;
		}
		if (cd_counter > 0)
			cd_counter--;
	}
	EntitySkillState::SubStep();
}

void CS_KanpaGrapplingHook::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
	{
		//ʼ
		auto we = e.lock();
		if (!we)
			return;
		auto mychar = std::static_pointer_cast<CS_Kanpa>(we);
		enable = true;
		//
		mychar->action_timecounter = mychar->action_timecounter_max;
		cd_counter = cd_counter_max;
		//Ϸ㹳
		auto am = std::make_shared<CS_KanpaGrapplingHookBlade>(we);
		am->x = we->x;
		am->y = we->y;
		//am->vx = we->vx;
		am->vy = -0x800 / ts;
		hook = am;
		we->gameFunc->SetEntity(we, am);
		//ס
		mychar->input.key &= ~keyMask;
		mychar->inputLock.key |= keyMask;
		mychar->input.SetJump(false);
		mychar->inputLock.SetJump(true);
	}
	else
		enable = false;
}

void CS_KanpaGrapplingHook::QuitHook()
{
	auto we = e.lock();
	if (we)
	{
		auto mychar = std::static_pointer_cast<CS_Kanpa>(we);
		//˳
		mychar->action_timecounter = 0;
		mychar->input.key &= ~keyMask;
		mychar->inputLock.key |= keyMask;
	}
	hook.reset();
}
