#pragma once
#include "Entity.h"
#include "EntityState.h"
#include "EntityStateFlashEffect.h"
#include "EntityStateInvincible.h"
#include "EntityStateGravity.h"
#include "CS_QuoteGravity.h"
#include "CS_KanpaWater.h"
#include "CS_KanpaDrown.h"
#include "CS_KanpaControl.h"
#include "CS_KanpaControl2.h"
#include "CS_KanpaResist.h"
#include "CS_KanpaResist2.h"
#include "CS_KanpaJump.h"
#include "CS_KanpaStand.h"
#include "CS_KanpaMove.h"
#include "CS_KanpaAir.h"
#include "CS_KanpaFaceToBack.h"
#include "CS_KanpaHurt.h"
#include "CS_KanpaStepOn.h"
#include "CS_KanpaFishing.h"
#include "CS_KanpaGrapplingHook.h"
//
#include "CS_KanpaAniHook.h"
#define CS_KANPA_CREATENAME L"CS_mychar_kanpa"
//ҽɫ 
class CS_Kanpa :
    public MyCharEntity
{
public:
    CS_Kanpa();
    void Init(std::weak_ptr<Entity> self) override;
    void Step() override;
    void SetState(int stateID, int lr) override;
    void SetState(std::wstring stateName, int lr) override;
    void LoadSaveData() override;//ر
    void WriteSaveData() override;//д뱣
    bool Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage) override;
    void Gain(std::weak_ptr<Entity> item) override;
    void GetCameraPos(float* outX, float* outY) override;
    void GetIcon(std::wstring& png, std::wstring& sprite_index, int& image_index, std::set<int>& hideLayerList) override;
    void CrushDeath();
    //ͼʾ
    bool showFishingRod = 0;//Ƿʾ
    float animation_moveSpeed = 0x200 / ts;
    bool animation_delay = false;//·ӳһ֡뵽
    //״̬ģ
    EntityStateFlashEffect stateFlash;
    EntityStateInvincible stateInvincible;
    CS_QuoteGravity stateGravity;
    EntityStateGravity stateGravity2;
    CS_KanpaWater stateWater;
    CS_KanpaDrown stateDrown;
    CS_KanpaControl stateControl;
    CS_KanpaControl2 stateControl2;
    CS_KanpaResist stateResist;
    CS_KanpaResist2 stateResist2;
    CS_KanpaJump stateJump;
    CS_KanpaStand stateStand;
    CS_KanpaMove stateMove;
    CS_KanpaAir stateAir;
    CS_KanpaFaceToBack stateFaceToBack;
    CS_KanpaHurt stateHurt;
    //ģ
    CS_KanpaStepOn skillStepOn;
    CS_KanpaFishing skillFishing;
    CS_KanpaGrapplingHook skillGrapplingHook;
    //
    std::weak_ptr<CS_KanpaAniHook> aniHook;
    bool hook_ani_set_target = false;
    //ƶģʽ
    int moveMode = 0;//0أ1һ
    int face = 0;//
    bool showSweat = false;
    int showSweat_counter = 0;
    int showSweat_counter_max = 24;
    std::wstring crushEvent;
private:
    void AnimateStep();//
};

std::shared_ptr<Entity> CreateCS_Kanpa();