#include "CS_JackStand.h"
const int CS_JackSTATENAME_STAND = ++entityStateID;
CS_JackStand::CS_JackStand()
{
	stateID = CS_JackSTATENAME_STAND;
	wink_counter = 0;
}

void CS_JackStand::State()
{
	auto we = e.lock();
	if (!we)
		return;

	const wchar_t* stand = L"";
	if (we->ud == -1)
		stand = we->lr == 0 ? L"mc_jack_stand_lu" : L"mc_jack_stand_ru";
	else
		stand = we->lr == 0 ? L"mc_jack_stand_l" : L"mc_jack_stand_r";
	we->ani.sprite_index = stand;
	//գ
	if (Random(0, 120) == 10)
	{
		wink_counter = 8;
	}
	if (wink_counter > 0)
	{
		wink_counter--;
		we->ani.image_index = 1;
	}
	else
	{
		we->ani.image_index = 0;
	}
}

void CS_JackStand::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
		enable = true;
	else
		enable = false;
}
