#include "CS_JackFishHurt.h"
const int CS_JackFishSTATENAME_HURT = ++entityStateID;
CS_JackFishHurt::CS_JackFishHurt()
{
	stateID = CS_JackFishSTATENAME_HURT;
}

void CS_JackFishHurt::State()
{
	auto we = e.lock();
	if (!we)
		return;

	we->ani.sprite_index = we->lr == 0 ? L"mc_jackfish_hurt_l" : L"mc_jackfish_hurt_r";
}

void CS_JackFishHurt::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
	{
		auto we = e.lock();
		if (!we)
			return;

		auto mychar = std::static_pointer_cast<MyCharEntity>(we);
		enable = true;
		mychar->action_timecounter = 30;
	}
	else
		enable = false;
}
