#include "CS_FortBlock.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include <PeSmog.h>

CS_FortBlock::CS_FortBlock()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_fortblock";
	cbRect.left = 16;
	cbRect.top = 16;
	cbRect.right = 16;
	cbRect.bottom = 16;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
	hp_max = hp = 2000;
	dropExp = 20;
}

void CS_FortBlock::Init(std::weak_ptr<Entity> self)
{
	x += 0x1000 / ts;
	y += 0x1000 / ts;
	last_x = x;
	last_y = y;
	Entity::Init(self);
}

void CS_FortBlock::Step()
{
	if (vy > 0)
	{
		if (++move_counter % 8 == 0)
			gameFunc->PlaySound(L"CS_026_quake");
	}
	if (bSetLanding && cbRect.cbBottom)
	{
		bSetLanding = false;
		for (int i = 0; i < 4; ++i)
		{
			auto pe = std::make_shared<CS_PeSmoke>();
			pe->x = x;
			pe->y = y;
			pe->vx = Random(-341, 341) / ts;
			pe->vy = Random(-0x600, 0) / ts;
			gameFunc->SetEntity(shared_from_this(), pe);
		}
	}
	ani.image_index = (int)((1- (float)hp / hp_max) * 5);
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_FortBlock::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"press")
	{
		vy = moveSpeed;
		bSetLanding = true;
		cbRect.enableCbRect = true;
		cbRect.enableSoild = true;
	}
	else if (stateName == L"destroy")
	{
		for (int i = 0; i < 4; ++i)
		{
			auto pe = std::make_shared<CS_PeSmoke>();
			pe->x = x;
			pe->y = y;
			pe->vx = Random(-341, 341) / ts;
			pe->vy = Random(-0x600, 0) / ts;
			gameFunc->SetEntity(shared_from_this(), pe);
		}
		gameFunc->PlaySound(L"CS_072_big_crash");
		Destroy();
	}
	else if (stateName == L"adjust_pos")
	{
		x += 0x1000 / ts;
		y += 0x1000 / ts;
	}
	else if (stateName == L"set_smog")
	{
		SetPeSmog(shared_from_this(), x, y, 1, 1, 90);
	}
}

bool CS_FortBlock::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	}
	else
	{
		gameFunc->PlaySound(L"CS_072_big_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_FortBlock()
{
	return std::make_shared<CS_FortBlock>();
}
