#include "CS_FallBlock.h"
#include "CS_PeSmoke.h"

CS_FallBlock::CS_FallBlock()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_fallblock";
	cbRect.enableCbRect = false;
	cbRect.enableSoild = false;
	cbRect.enableSelfSoild = false;
	cbRect.enableMovePlatform = false;
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 16;

}

void CS_FallBlock::Init(std::weak_ptr<Entity> self)
{
	stateSplash.Init(self);
	Entity::Init(self);
}

void CS_FallBlock::Step()
{
	if (bAdjustPos)
	{
		bAdjustPos = false;
		x += 8;
		y += 8;
		//ִ˶
		Entity::Step();
	}
	if (bStatic)
		return;
	stateSplash.Step();
	if (bFallState)
	{
		vy += 0x40 / ts;
		if (vy > 0x700 / ts)
			vy = 0x700 / ts;
	}
	if (cbRect.cbBottom && bFallState)
	{
		bFallState = false;
		gameFunc->PlaySound(L"CS_026_quake");
		if (gameFunc->SetQuake)
			gameFunc->SetQuake(gameFunc->game, 10, 0);
		//
		for (int i = 0; i < 4; ++i)
		{
			auto pe = std::make_shared<CS_PeSmoke>();
			pe->x = x + Random(-12, 12);
			pe->y = y + 0x2000 / ts;
			pe->vx = Random(-341, 341) / ts;
			pe->vy = Random(-0x600, 0) / ts;
			gameFunc->SetEntity(shared_from_this(), pe);
		}
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_FallBlock::SetState(int stateID, int lr)
{
	cbRect.enableCbRect = lr != 0;
	cbRect.enableSoild = lr != 0;
	cbRect.enableSelfSoild = lr != 0;
	cbRect.enableMovePlatform = lr != 0;
}

void CS_FallBlock::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"static")
	{
		bStatic = true;
		cbRect.enableSelfSoild = true;
		cbRect.enableMovePlatform = true;
	}
}

std::shared_ptr<Entity> CreateCS_FallBlock()
{
	return std::make_shared<CS_FallBlock>();
}
