#include "CS_Enemy_TrackingBomb.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_PeCountdown.h"
#include "CS_Enemy_TrackingBombSmall.h"
CS_Enemy_TrackingBomb::CS_Enemy_TrackingBomb()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_counterbomb";
	ani.hideLayerList.insert(0);
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 10;
	hp_max = hp = 127;
	dropExp = 7;
	drawBeforeOtherEntity = true;
	attackState = false;
	noDir = true;
}

void CS_Enemy_TrackingBomb::Step()
{
	if (bExplode)
	{
		//Сը
		Explode();
		Destroy();
		return;
	}
	switch (act_no)
	{
	case 0:
		act_no = 1;
		tgt_x = x;
		tgt_y = y;
		count1 = 120;
		act_wait = Random(0, 50);
		[[fallthrough]];
	case 1:
		if (++act_wait < 50)
			break;
		act_wait = 0;
		act_no = 2;
		vy = 0x300 / ts;
		break;
	case 2:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (lr == 0)
				{
					if (abs(wplayer->x - x) <= 80 && abs(wplayer->y - y) <= 80)
					{
						if (target.expired())
							target = wplayer;
						act_wait = 0;
						act_no = 3;
					}
				}
				else
				{
					if (target.expired())
						target = wplayer;
					act_wait = 0;
					act_no = 3;
				}
			}
		}
		if (shock_counter > 0)
		{
			act_wait = 0;
			act_no = 3;
		}
		break;
	case 3:
		switch (act_wait)
		{
		case 60 * 0:
			countdown = SetCS_PeCountdown(shared_from_this(), x + 16, y + 4, 5);
			break;
		case 60 * 1:
			countdown = SetCS_PeCountdown(shared_from_this(), x + 16, y + 4, 4);
			break;
		case 60 * 2:
			countdown = SetCS_PeCountdown(shared_from_this(), x + 16, y + 4, 3);
			break;
		case 60 * 3:
			countdown = SetCS_PeCountdown(shared_from_this(), x + 16, y + 4, 2);
			break;
		case 60 * 4:
			countdown = SetCS_PeCountdown(shared_from_this(), x + 16, y + 4, 1);
			break;
		case 60 * 5:
			attackState = true;
			cbRect.left = cbRect.right = 128;
			cbRect.top = cbRect.bottom = 100;
			gameFunc->PlaySound(L"CS_035_explosion1");
			SetCS_PeSmoke(shared_from_this(), x, y, 100);
			if (gameFunc->SetQuake)
				gameFunc->SetQuake(gameFunc->game, 20, 0);
			bExplode = true;
			ani.png = L"";
			break;
		}
		++act_wait;
		break;
	}
	if (act_no == 3)
	{
		//׷Ŀ
		auto wtarget = target.lock();
		if (wtarget)
		{
			const float speed = 0x200 / ts;
			float vec_x = wtarget->x - x;
			float vec_y = wtarget->y - y;
			auto vec = XMVector2Normalize(XMVectorSet(vec_x, vec_y, 0, 0));
			float dir_vx = XMVectorGetX(vec);
			float dir_vy = XMVectorGetY(vec);
			vx = dir_vx * speed;
			vy = dir_vy * speed;
		}
	}
	else if (act_no > 1)
	{
		if (tgt_y < y)
			vy -= 0x10 / ts;
		if (tgt_y > y)
			vy += 0x10 / ts;
		if (vy > 0x100 / ts)
			vy = 0x100 / ts;
		if (vy < -0x100 / ts)
			vy = -0x100 / ts;
	}
	//ִ˶
	Entity::Step();
	auto wcountdown = countdown.lock();
	if (wcountdown)
	{
		wcountdown->last_x = wcountdown->x;
		wcountdown->last_y = wcountdown->y;
		wcountdown->x = x + 16 + wcountdown->dx;
		wcountdown->y = y + 4 + wcountdown->dy;
	}
}

void CS_Enemy_TrackingBomb::SetState(int stateID, int lr)
{
	this->lr = lr;
	act_no = stateID;
}

void CS_Enemy_TrackingBomb::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 30;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_TrackingBomb::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	if (target.expired())
	{
		target = src;
		auto wsrc = src.lock();
		if (wsrc)
		{
			auto wattackParent = wsrc->attackParent.lock();
			if (wattackParent)
				target = wattackParent;
		}
	}
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	}
	else
	{
		gameFunc->PlaySound(L"CS_072_big_crash");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		//Сը
		Explode();
		Destroy();
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Enemy_TrackingBomb::Explode()
{
	for (int i = 0; i < 5; i++)
	{
		float setX = x + Random(-128, 128);
		float setY = y + Random(-100, 100);
		for (size_t i = 0; i < 3; i++)
		{
			auto e = std::make_shared<CS_PeSmoke>();
			e->x = setX;
			e->y = setY;
			e->lr = lr;
			gameFunc->SetEntity(shared_from_this(), e);
		}
		SetCS_Enemy_TrackingBombSmall(shared_from_this(), setX, setY, target);
	}
}

std::shared_ptr<Entity> CreateCS_Enemy_TrackingBomb()
{
	return std::make_shared<CS_Enemy_TrackingBomb>();
}
