#include "CS_Enemy_Puchi.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_Puchi::CS_Enemy_Puchi()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.left = cbRect.right = 4;
	cbRect.top = 4;
	cbRect.bottom = 5;
	cbRect.fullWaterBlock = true;
	hp_max = hp = 2;
	dropExp = 2;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_Puchi::Init(std::weak_ptr<Entity> self)
{
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_Puchi::Step()
{
	auto& ani_no = ani.image_index;
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateResist.apply_resistH = cbRect.cbBottom;
	stateResist.Step();
	stateSplash.Step();
	switch (act_no)
	{
	case 0:
		act_no = 1;
		act_wait = 0;
		vx = 0;
		vy = 0;

		if (ud == 1)
		{
			if (Random(0, 1))
				lr = 0;
			else
				lr = 1;
			ud = 0;
			cbRect.enableSoild = false;
			ani_no = 2;
			act_no = 3;
			break;
		}
		else
		{
			cbRect.enableSoild = true;
		}
		[[fallthrough]];
	case 1:
		++act_wait;
		if (Random(0, 50) == 1)
		{
			act_no = 2;
			act_wait = 0;
			ani_no = 0;
			ani_wait = 0;
			break;
		}
		break;
	case 2:
		++act_wait;
		if (++ani_wait > 2)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 1)
			ani_no = 0;
		if (act_wait > 18)
		{
			act_no = 1;
			act_no = 1;
		}
		break;
	case 3:
		if (++act_wait > 40)
			cbRect.enableSoild = true;
		if (cbRect.cbBottom)
		{
			act_no = 0;
			ani_no = 0;
			act_wait = 0;
		}
		break;
	case 10:
		act_no = 11;
		[[fallthrough]];
	case 11:
		if (cbRect.cbLeft)
		{
			vx = abs(vx);
			lr = 1;
		}
		if (cbRect.cbRight)
		{
			vx = -abs(vx);
			lr = 0;
		}
		if (cbRect.cbBottom)
		{
			act_no = 0;
			ani_no = 0;
			act_wait = 0;
		}
		break;
	}

	BOOL bJump = FALSE;
	if (act_no < 10 && act_no != 3 && act_wait > 10)
	{
		if (shock_counter > 0)
			bJump = TRUE;
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (!(x < wplayer->x - 0x14000 / ts || x > wplayer->x + 0x14000 / ts ||
					y < wplayer->y - 0x8000 / ts || y > wplayer->y + 0x8000 / ts))
				{
					if (Random(0, 50) == 2)
						bJump = TRUE;
				}
			}
		}
	}
	if (bJump)
	{
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (x > wplayer->x)
					lr = 0;
				else
					lr = 1;
			}
		}
		act_no = 10;
		ani_no = 2;
		vy = -0x2FF / ts;
		gameFunc->PlaySound(L"CS_006");
		if (lr == 0)
			vx = -0x100 / ts;
		else
			vx = 0x100 / ts;
	}
	vy += 0x80 / ts;
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
	ani.sprite_index = lr == 0 ? L"ls_puchi_l" : L"ls_puchi_r";
}

void CS_Enemy_Puchi::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_puchi_l" : L"ls_puchi_r";
}

void CS_Enemy_Puchi::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 1;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Puchi::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_055_enemy_squeak2");
	}
	else
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Puchi()
{
	return std::make_shared<CS_Enemy_Puchi>();
}
