#include "CS_Enemy_PowerCritter.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_PowerCritter::CS_Enemy_PowerCritter()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.left = cbRect.right = 6;
	cbRect.top = 4;
	cbRect.bottom = 5;
	cbRect.fullWaterBlock = true;
	hp_max = hp = 16;
	dropExp = 7;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_PowerCritter::Init(std::weak_ptr<Entity> self)
{
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_PowerCritter::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateResist.apply_resistH = cbRect.cbBottom;
	stateResist.Step();
	stateSplash.Step();
	switch (act_no)
	{
	case 0:
		y += 0x600 / ts;
		act_no = 1;
		[[fallthrough]];
	case 1:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (act_wait >= 8 && x - 0x10000 / ts < wplayer->x && x + 0x10000 / ts > wplayer->x && y - 0x10000 / ts < wplayer->y && y + 0x6000 / ts > wplayer->y)
				{
					if (x > wplayer->x)
						lr = 0;
					else
						lr = 1;
					ani_no = 1;
				}
				else
				{
					if (act_wait < 8)
						++act_wait;

					ani_no = 0;
				}
				if (act_wait >= 8 && x - 0xC000 / ts < wplayer->x && x + 0xC000 / ts > wplayer->x && y - 0xC000 / ts < wplayer->y && y + 0x6000 / ts > wplayer->y)
				{
					act_no = 2;
					ani_no = 0;
					act_wait = 0;
				}
			}
		}
		if (shock_counter > 0)
		{
			act_no = 2;
			ani_no = 0;
			act_wait = 0;
		}
		break;
	case 2:
		if (++act_wait > 8)
		{
			act_no = 3;
			ani_no = 2;
			vy = -0x5FF / ts;
			gameFunc->PlaySound(L"CS_108");
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					lr = x > wplayer->x ? 0 : 1;
				}
			}
			vx = lr == 0 ? -0x100 / ts : 0x100 / ts;
		}
		break;
	case 3:
		if (vy > 0x200 / ts)
		{
			tgt_y = y;
			act_no = 4;
			ani_no = 3;
			act_wait = 0;
			act_wait = 0;	// Pixel duplicated this line
		}
		break;
	case 4:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				lr = x > wplayer->x ? 0 : 1;
			}
		}
		++act_wait;
		if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || act_wait > 100)
		{
			damage = 12;
			act_no = 5;
			ani_no = 2;
			vx /= 2;
		}
		else
		{
			if (act_wait % 4 == 1)
				gameFunc->PlaySound(L"CS_110");
			if (++ani_wait > 0)
			{
				ani_wait = 0;
				++ani_no;
			}
			if (ani_no > 5)
				ani_no = 3;
		}
		break;
	case 5:
		if (cbRect.cbBottom)
		{
			damage = 2;
			vx = 0;
			act_wait = 0;
			ani_no = 0;
			act_no = 1;
			gameFunc->PlaySound(L"CS_026_quake");
			if (gameFunc->SetQuake)
				gameFunc->SetQuake(gameFunc->game, 30, 0);
		}
		break;
	}
	if (act_no != 4)
	{
		vy += 0x20 / ts;
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
	}
	else
	{
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (x < wplayer->x)
					vx += 0x20 / ts;
				else
					vx -= 0x20 / ts;
			}
		}
		if (y > tgt_y)
			vy -= 0x10 / ts;
		else
			vy += 0x10 / ts;
		if (vy > 0x200 / ts)
			vy = 0x200 / ts;
		if (vy < -0x200 / ts)
			vy = -0x200 / ts;
		if (vx > 0x200 / ts)
			vx = 0x200 / ts;
		if (vx < -0x200 / ts)
			vx = -0x200 / ts;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
	ani.sprite_index = lr == 0 ? L"ls_powercritter_l" : L"ls_powercritter_r";
	ani.image_index = ani_no;
}

void CS_Enemy_PowerCritter::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_powercritter_l" : L"ls_powercritter_r";
}

void CS_Enemy_PowerCritter::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = damage;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_PowerCritter::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_051_enemy_hurt");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_PowerCritter()
{
	return std::make_shared<CS_Enemy_PowerCritter>();
}
