#include "CS_Enemy_Piranha.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_Piranha::CS_Enemy_Piranha()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.left = cbRect.right = 19;
	cbRect.top = cbRect.bottom = 8;
	hp_max = hp = 32;
	dropExp = 9;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	ignoreTrap = true;
	action_timecounter = Random(30, 60);
}

void CS_Enemy_Piranha::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_Piranha::Step()
{
	if (!cbRect.inWater)
		stateGravity.Step();
	stateSplash.Step();
	//
	vx /= 1.01f;
	vy /= 1.01f;
	if (abs(vx) < 0.001f)
		vx = 0;
	if (abs(vy) < 0.001f)
		vy = 0;
	if (cbRect.inWater)
	{
		switch (stateID)
		{
		case 0:
			if (cbRect.inWater && action_timecounter > 0)
				action_timecounter--;
			if (action_timecounter == 0)
			{
				stateID = 1;
			}
			break;
		case 1://ٶ
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					float dx = wplayer->x - x;
					float dy = wplayer->y - y;
					if (!(dx == 0 && dy == 0))
					{
						auto angle = XMConvertToDegrees(XMVectorGetX(XMVector2AngleBetweenVectors(XMVectorSet(1, 0, 0, 0), XMVectorSet(dx, dy, 0, 0))));
						if (dy < 0)
							angle = 360 - angle;
						float dstDeg = 360.0f / 255.0f;
						float deg = angle + Random(-30, 30) * dstDeg;
						vy = 2 * sinf(deg * deg2rad);
						vx = 2 * cosf(deg * deg2rad);
					}
					face = dx * dx + dy * dy < 128 * 128 ? 1 : 0;
				}
			}
			stateID = 2;
			break;
		case 2://Ŀȥ
			if (++action_timecounter > 50)
			{
				action_timecounter = 120;
				stateID = 0;
			}
			break;
		}
	}
	//ǽڷ
	if (cbRect.cbLeft)
	{
		lr = 1;
		vx = abs(vx);
	}
	if (cbRect.cbRight)
	{
		lr = 0;
		vx = -abs(vx);
	}
	if (cbRect.cbTop)
		vy = abs(vy);
	if (cbRect.cbBottom)
		vy = -abs(vy);
	lr = vx > 0 ? 1 : 0;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//
	ani.image_counter_speed = max(abs(vx), abs(vy)) * 2;
	if (ani.image_counter_speed < 0.1f)
		ani.image_index = 0;
	if (face == 0)
	{
		//
		ani.hideLayerList.erase(0);
		ani.hideLayerList.insert(1);
	}
	else
	{
		//
		ani.hideLayerList.insert(0);
		ani.hideLayerList.erase(1);
	}
	//˸
	if (flash_counter > 0)
	{
		if (flash_counter / 2 % 2 == 0)
			ani.png = L"";
		else
			ani.png = L"CS_CaveStoryMod";
		flash_counter--;
	}
	else
		ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = lr == 0 ? L"ls_piranha_l" : L"ls_piranha_r";
}

void CS_Enemy_Piranha::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	ani.sprite_index = lr == 0 ? L"ls_piranha_l" : L"ls_piranha_r";
}

void CS_Enemy_Piranha::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 5;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Piranha::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	flash_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_sea_enemy_hurt0");
	}
	else
	{
		gameFunc->PlaySound(L"CS_sea_destroy1");
		//
		SetCS_PeSmokeWater(shared_from_this(), x, y, 3);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Piranha()
{
	return std::make_shared<CS_Enemy_Piranha>();
}
