#include "CS_Enemy_NightSpirit.h"
#include "CS_Exp.h"
#include "CS_PeSmoke.h"
#include "CS_AmNightSpirit.h"
CS_Enemy_NightSpirit::CS_Enemy_NightSpirit()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 8;
	cbRect.top = cbRect.bottom = 16;
	hp_max = hp = 64;
	dropExp = 22;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	ignoreTrap = true;
}

void CS_Enemy_NightSpirit::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		ani_no = 0;
		tgt_x = x;
		tgt_y = y;
		[[fallthrough]];
	case 1:
		if (gameFunc->InScreen(gameFunc->entityRes, x, y))
		{
			if (gameFunc->GetPlayerDistanceLR)
			{
				auto wplayer = gameFunc->GetPlayerDistanceLR(gameFunc->game, x, y, lr).lock();
				if (wplayer)
				{
					if (wplayer->y > y - 0x1000 / ts && wplayer->y < y + 0x1000 / ts)
					{
						if (lr == 0)
							y -= 0x1E000 / ts;
						else
							y += 0x1E000 / ts;
						act_no = 10;
						act_wait = 0;
						ani_no = 1;
						vy_set = 0;
						bShootable = true;
					}
				}
			}
		}
		break;
	case 10:
		if (++ani_wait > 2)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 3)
			ani_no = 1;
		if (++act_wait > 200)
		{
			act_no = 20;
			act_wait = 0;
			ani_no = 4;
		}
		break;
	case 20:
		if (++ani_wait > 2)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 6)
			ani_no = 4;
		if (++act_wait > 50)
		{
			act_no = 30;
			act_wait = 0;
			ani_no = 7;
		}
		break;
	case 30:
		if (++ani_wait > 2)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 9)
			ani_no = 7;
		if (++act_wait % 5 == 1)
		{
			auto vx = lr == 0 ? Random(2, 12) / 4.0f : Random(-12, 2) / 4.0f;
			SetCS_AmNightSpirit(shared_from_this(), x, y, vx, Random(-0x200, 0x200) / ts);
			gameFunc->PlaySound(L"CS_021_bubble");
		}
		if (act_wait > 50)
		{
			act_no = 10;
			act_wait = 0;
			ani_no = 1;
		}
		break;
	case 40:
		if (y < tgt_y)
			vy_set += 0x40 / ts;
		else
			vy_set -= 0x40 / ts;
		if (vy_set < -0x400 / ts)
			vy_set = -0x400 / ts;
		if (vy_set > 0x400 / ts)
			vy_set = 0x400 / ts;
		if (shock_counter > 0)
			vy = vy_set / 2;
		else
			vy = vy_set;
		if (++ani_wait > 2)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 6)
			ani_no = 4;
		if (gameFunc->GetPlayerDistanceLR)
		{
			auto wplayer = gameFunc->GetPlayerDistanceLR(gameFunc->game, x, y, lr).lock();
			if (wplayer)
			{
				if (wplayer->y < tgt_y + 0x1E000 / ts && wplayer->y > tgt_y - 0x1E000 / ts)
				{
					act_no = 20;
					act_wait = 0;
					ani_no = 4;
				}
			}
		}
		break;
	}
	if (act_no >= 10 && act_no <= 30)
	{
		if (gameFunc->GetPlayerDistanceLR)
		{
			auto wplayer = gameFunc->GetPlayerDistanceLR(gameFunc->game, x, y, lr).lock();
			if (wplayer)
			{
				if (y < wplayer->y)
					vy_set += 25 / ts;
				else
					vy_set -= 25 / ts;
				if (wplayer->y > tgt_y + 0x1E000 / ts || wplayer->y < tgt_y - 0x1E000 / ts)
					act_no = 40;
			}
		}
		if (vy_set < -0x400 / ts)
			vy_set = -0x400 / ts;
		if (vy_set > 0x400 / ts)
			vy_set = 0x400 / ts;
		if (cbRect.cbTop)
			vy_set = 0x200 / ts;
		if (cbRect.cbBottom)
			vy_set = -0x200 / ts;
		if (shock_counter > 0)
			vy = vy_set / 2;
		else
			vy = vy_set;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_Enemy_NightSpirit::SetState(int stateID, int lr)
{
	this->lr = lr;
	act_no = stateID;
	ani.sprite_index = lr == 0 ? L"ls_nightspirit_l" : L"ls_nightspirit_r";
	ani.image_index = 1;
}

bool CS_Enemy_NightSpirit::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	if (!bShootable)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	}
	else
	{
		gameFunc->PlaySound(L"CS_072_big_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		if (lr == 0)
			SetDropItemLFloat(shared_from_this(), x, y, dropExp);
		else
			SetDropItemRFloat(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy_set = shockForce * sinf(radian);
		vy_set -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 32, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_NightSpirit()
{
	return std::make_shared<CS_Enemy_NightSpirit>();
}
