#include "CS_Enemy_LavaCritter.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_AmLava.h"
CS_Enemy_LavaCritter::CS_Enemy_LavaCritter()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.left = cbRect.right = 6;
	cbRect.top = 4;
	cbRect.bottom = 5;
	cbRect.fullWaterBlock = true;
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(1);
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(3);
	hp_max = hp = 6;
	dropExp = 1;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_LavaCritter::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_LavaCritter::Step()
{
	auto& ani_no = ani.image_index;
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateResist.apply_resistH = cbRect.cbBottom;
	stateGravity.Step();
	stateResist.Step();
	stateSplash.Step();
	switch (act_no)
	{
	case 0: // Initialize
		y += 0x600 / ts;
		act_no = 1;
		[[fallthrough]];
	case 1: // Waiting
		// Look at player
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (x > wplayer->x)
					lr = 0;
				else
					lr = 1;
				// Open eyes near player
				if (act_wait >= 8 && x - 0x12000 / ts < wplayer->x && x + 0x12000 / ts > wplayer->x && y - 0xA000 / ts < wplayer->y && y + 0xA000 / ts > wplayer->y)
				{
					ani_no = 1;
				}
				else
				{
					if (act_wait < 8)
						++act_wait;

					ani_no = 0;
				}
				// Jump if player is nearby
				if (act_wait >= 8 && x - 0xC000 / ts < wplayer->x && x + 0xC000 / ts > wplayer->x && y - 0xA000 / ts < wplayer->y && y + 0xC000 / ts > wplayer->y)
				{
					act_no = 2;
					ani_no = 0;
					act_wait = 0;
				}
			}
		}

		// Jump if attacked
		if (shock_counter > 0)
		{
			act_no = 2;
			ani_no = 0;
			act_wait = 0;
		}
		break;

	case 2: // Going to jump
		if (++act_wait > 8)
		{
			// Set jump state
			act_no = 3;
			ani_no = 2;

			// Jump
			vy = -0x5FF / ts;
			gameFunc->PlaySound(L"CS_030_critter_jump");

			// Jump in facing direction
			if (lr == 0)
				vx = -0x200 / ts;
			else
				vx = 0x200 / ts;
		}
		break;

	case 3: // Jumping
		// Land
		if (cbRect.cbBottom)
		{
			vx = 0;
			act_wait = 0;
			ani_no = 0;
			act_no = 1;
			gameFunc->PlaySound(L"CS_023_thud");
		}
		break;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
	//
	if (cbRect.cbBottom)
		ani.sprite_index = lr == 0 ? L"ls_critter_stand_l" : L"ls_critter_stand_r";
	else
		ani.sprite_index = lr == 0 ? L"ls_critter_jump_l" : L"ls_critter_jump_r";
}

void CS_Enemy_LavaCritter::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_critter_stand_l" : L"ls_critter_stand_r";
}

void CS_Enemy_LavaCritter::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 6;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_LavaCritter::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_051_enemy_hurt");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
		//
		SetCS_AmLava(shared_from_this(), x, y, Random(-0x300, 0x300) / ts, Random(-0x500, -0x200) / ts);
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_LavaCritter()
{
	return std::make_shared<CS_Enemy_LavaCritter>();
}
