#include "CS_Enemy_LaserTrap.h"
#include "CS_Enemy_LaserTrapBlade.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include <PeSmog.h>
CS_Enemy_LaserTrap::CS_Enemy_LaserTrap()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_lasertrap_dark";
	hp_max = hp = 20;
	dropExp = 9;
}

void CS_Enemy_LaserTrap::Init(std::weak_ptr<Entity> self)
{
	auto wsignt = std::make_shared<CS_Enemy_LaserTrapSight>();
	signt = wsignt;
	wsignt->x = x;
	wsignt->y = y;
	gameFunc->SetEntity(shared_from_this(), wsignt);
	Entity::Init(self);
}

void CS_Enemy_LaserTrap::Step()
{
	if (delay_counter > 0)
	{
		delay_counter--;
		ani.sprite_index = L"ls_lasertrap_dark";
		return;
	}
	switch (stateID)
	{
	case 0://ȴ׶
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			action_timecounter = 120;//׼׶εʱ
			//ѡһҪ
			if (gameFunc->GetPlayerDistance)
				target = gameFunc->GetPlayerDistance(gameFunc->game, x, y);
			stateID = 1;//׼׶
		}
		//ʹ߲
		if(action_timecounter <= 3)
		{
			auto wsignt = signt.lock();
			if (wsignt)
			{
				//ٵҷλ
				auto wtarget = target.lock();
				if (wtarget)
				{
					auto vec = XMVector2Normalize(XMVectorSet(wtarget->x - x, wtarget->y - y, 0, 0));
					float dirX = XMVectorGetX(vec);
					float dirY = XMVectorGetY(vec);
					wsignt->x = x;
					wsignt->y = y;
					wsignt->TestDistance(x, y, dirX, dirY);
					lineX = wsignt->x - x;
					lineY = wsignt->y - y;
					last_lineX = lineX;
					last_lineY = lineY;
				}
				else
				{
					//ѡһҪ
					if (gameFunc->GetPlayerDistance)
						target = gameFunc->GetPlayerDistance(gameFunc->game, x, y);
				}
			}
		}
		ani.sprite_index = L"ls_lasertrap_dark";
		break;
	case 1://׼׶
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			action_timecounter = 30;//óܽ׶
			stateID = 2;//빥׶
		}
		//ʹ߲
		{
			auto wsignt = signt.lock();
			if (wsignt)
			{
				//ٵҷλ
				auto wtarget = target.lock();
				if (wtarget)
				{
					auto vec = XMVector2Normalize(XMVectorSet(wtarget->x - x, wtarget->y - y, 0, 0));
					float dirX = XMVectorGetX(vec);
					float dirY = XMVectorGetY(vec);
					wsignt->TestDistance(x, y, dirX, dirY);
				}
				else
				{
					//ѡһҪ
					if (gameFunc->GetPlayerDistance)
						target = gameFunc->GetPlayerDistance(gameFunc->game, x, y);
				}
			}
		}
		ani.sprite_index = L"ls_lasertrap_flash";
		break;
	case 2://ܽ׶
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			action_timecounter = 30;//ùʱ
			laser_color_counter = 0;
			stateID = 3;//ȴ׶
			//
			auto wsignt = signt.lock();
			if (wsignt)
			{
				auto vec = XMVector2Normalize(XMVectorSet(wsignt->x - x, wsignt->y - y, 0, 0));
				float dirX = XMVectorGetX(vec);
				float dirY = XMVectorGetY(vec);
				float setX = x;
				float setY = y;
				float srcDx = setX - x;
				float srcDy = setY - y;
				float dstDx = wsignt->x - x;
				float dstDy = wsignt->y - y;
				while (srcDx * srcDx + srcDy * srcDy < dstDx * dstDx + dstDy * dstDy)
				{
					auto am = SetCS_Enemy_LaserTrapBlade(shared_from_this(), setX, setY);
					am->exist_time = action_timecounter;
					setX += dirX * (am->cbRect.left + am->cbRect.right);
					setY += dirY * (am->cbRect.bottom + am->cbRect.top);
					srcDx = setX - x;
					srcDy = setY - y;
				}
			}
		}
		ani.sprite_index = L"ls_lasertrap_flash";
		break;
	case 3://׶
		laser_color_counter++;
		if (laser_color_counter / 2 % 2 == 0)
			laser_color = RGBA(0xff, 0xff, 0, 0xff);
		else
			laser_color = RGBA(0xff, 0, 0, 0xff);
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			action_timecounter = 180;//ȴ׶εʱ
			stateID = 0;//ȴ׶
			target.reset();
		}
		ani.sprite_index = L"ls_lasertrap_atk";
		break;
	}
	auto wsignt = signt.lock();
	if (wsignt)
	{
		//׼
		last_lineX = lineX;
		last_lineY = lineY;
		lineX = wsignt->x - x;
		lineY = wsignt->y - y;
	}
	//ִ˶
	Entity::Step();
}

void CS_Enemy_LaserTrap::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"delay")
	{
		delay_counter = lr;
	}
	else if (stateName == L"set_smog")
	{
		SetPeSmog(shared_from_this(), x, y, 1, 1, 90);
	}
}

void CS_Enemy_LaserTrap::DeltaTime(float deltaTime)
{
	lineList.clear();
	fillList.clear();
	switch (stateID)
	{
	case 0://
		break;
	case 1://׼
	case 2:
		{
			float nowTargetX = lerp(last_lineX, lineX, deltaTime);
			float nowTargetY = lerp(last_lineY, lineY, deltaTime);
			AddLine(lineList, 0, 0, 0, RGBA(0xff, 0, 0, 0xff), nowTargetX, nowTargetY, RGBA(0xff, 0, 0, 0xff));
		}
		break;
	case 3://ƹ
		{
			float nowTargetX = lerp(last_lineX, lineX, deltaTime);
			float nowTargetY = lerp(last_lineY, lineY, deltaTime);
			AddFillLine(fillList, 0, 0, 0, laser_color, nowTargetX, nowTargetY, laser_color, 3);
		}
		break;
	}
	Entity::DeltaTime(deltaTime);
}

void CS_Enemy_LaserTrap::Destroy()
{
	auto wsignt = signt.lock();
	if (wsignt)
		wsignt->Destroy();
	Entity::Destroy();
}

bool CS_Enemy_LaserTrap::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	}
	else
	{
		gameFunc->PlaySound(L"CS_072_big_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 32, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_LaserTrap()
{
	return std::make_shared<CS_Enemy_LaserTrap>();
}
