#include "CS_Enemy_GolemPaper.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "PeSmog.h"

CS_Enemy_GolemPaper::CS_Enemy_GolemPaper()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_golem_paper";
	ani.image_index = 2;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 8;
	cbRect.top = 32;
	cbRect.bottom = 8;
	hp_max = hp = 60;
	dropExp = 19;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_GolemPaper::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_GolemPaper::Step()
{
	stateGravity.Step();
	stateSplash.Step();
	if (wake_counter > 0)
	{
		wake_counter--;
	}
	switch (stateID)
	{
	case 0:
		type = 0;//αװ
		//if (lr != 0)
		//{
		//	//ҿʱԶ
		//	if (gameFunc->GetPlayerDistanceWithLineTest)
		//	{
		//		auto wplayer = gameFunc->GetPlayerDistanceWithLineTest(gameFunc->game, x, y).lock();
		//		if (wplayer)
		//		{
		//			if (abs(wplayer->x - x) <= 16 * 10)
		//			{
		//				//
		//				stateID = 1;
		//				break;
		//			}
		//		}
		//	}
		//}
		break;
	case 1://(жӳ٣
		SetCS_PeSmokeWater(shared_from_this(), x, y, 3);
		wake_counter = 120;
		stateID = 2;
		bAction = true;
		ani.image_index = 0;
		type = 2;//ԭ
		[[fallthrough]];
	case 2://жӳ
		if (wake_counter > 0)
			wake_counter--;
		if (wake_counter == 0)
			stateID = 3;
		break;
	case 3://ж(жģʽƽ)
		move_counter = 30;
		//ƽƷ
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				lr = x < wplayer->x ? 1 : 0;
				stateID = 4;
				target = wplayer;
			}
		}
		break;
	case 4://ֱƶĿһ
		if (!target.expired())
		{
			auto wtarget = target.lock();
			if (lr == 0 && x > wtarget->x)
			{
				if (vx > -0xa00 / ts)
					vx -= 0x40 / ts;
			}
			else if (lr != 0 && x < wtarget->x)
			{
				if (vx < 0xa00 / ts)
					vx += 0x40 / ts;
			}
			else
			{
				MoveOver();
			}
		}
		else
		{
			MoveOver();
		}
		break;
	case 5://ƽƵϢʱ
		if (moveinterval_counter > 0)
			moveinterval_counter--;
		else
			stateID = 3;
		if (abs(vx) > 0.001f)
			vx /= 1.1f;
		else
			vx = 0;
		break;
	case 6://׹
		ani.image_index = 0;
		vy += 0x20 / ts;
		if (drop_counter > 0)
		{
			drop_counter--;
			cbRect.enableCbRect = false;
			cbRect.enableSoild = false;
		}
		else
		{
			cbRect.enableCbRect = true;
			cbRect.enableSoild = true;
		}
		if (cbRect.enableSoild)
		{
			if (cbRect.cbBottom)
			{
				for (int i = 0; i < 4; i++)
				{
					auto pe = std::make_shared<CS_PeSmoke>();
					pe->x = x + Random(-12, 12);
					pe->y = y + Random(-12, 12);
					pe->vx = Random(-341, 341) / ts;
					pe->vy = Random(-0x600, 0) / ts;
					gameFunc->SetEntity(shared_from_this(), pe);
				}
				gameFunc->PlaySound(L"CS_026_quake");
				if (gameFunc->SetQuake)
					gameFunc->SetQuake(gameFunc->game, 30, 0);
				stateID = 7;
			}
		}
		//
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		if (vy < -0x5FF / ts)
			vy = -0x5FF / ts;
		break;
	case 7://
		break;
	case 8://
		ani.image_index = 1;
		if (abs(vx) > 0.001f)
			vx /= 1.1f;
		else
			vx = 0;
		break;
	}
	//Ƶٶȱ仯
	walkSound += abs(vx);
	if (walkSound > 32)
	{
		walkSound -= 32;
		gameFunc->PlaySound(L"CS_107_block_move");
		SetPeSmog(shared_from_this(), x, y, 1, 1, lr == 0 ? 0 : 180.0f);
	}
	if (cbRect.cbLeft)
	{
		vx = abs(vx);
		vy = -0x400 / ts;
		lr = 1;
		gameFunc->PlaySound(L"CS_071_little_crash");
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		if (gameFunc->SetQuake)
			gameFunc->SetQuake(gameFunc->game, 30, 0);
	}
	if (cbRect.cbRight)
	{
		vx = -abs(vx);
		vy = -0x400 / ts;
		lr = 0;
		gameFunc->PlaySound(L"CS_071_little_crash");
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		if (gameFunc->SetQuake)
			gameFunc->SetQuake(gameFunc->game, 30, 0);
	}
	srcVx = vx;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	vx = srcVx;
	//άб
	Entity::KeepOnSlopes();
}

void CS_Enemy_GolemPaper::SetState(int stateID, int lr)
{
	this->lr = lr;
	if (stateID < 1000)
	{
		this->stateID = stateID;
		switch (stateID)
		{
		case 3:
			type = 2;//ԭ
			break;
		}
	}
	else
	{
		this->stateID = 6;
		drop_counter = stateID - 1000;
		cbRect.enableCbRect = false;
		cbRect.enableSoild = false;
		//һײ
		Entity::ClearCollisionResult();
	}
}

void CS_Enemy_GolemPaper::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, 0);
	else if (stateName == L"wake")
		SetState(1, 0);
	else if (stateName == L"action")
	{
		bAction = true;
		SetState(3, 0);
	}
}

void CS_Enemy_GolemPaper::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (!bAction)
		return;
	if (hp <= 0)
		return;
	*outDamage = (int)lerp(5, 10, abs(vx) / (0xa00 / ts));
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = lerp(0x200 / ts, 0x800 / ts, abs(vx) / (0xa00 / ts));
	*outHeavy = 2;
}

bool CS_Enemy_GolemPaper::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (!bAction)
		return false;
	if (getDamage < 5)
	{
		*outRealDamage = 0;
		return true;
	}
	if (hp == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		stateID = 8;
		damage_reset_counter = -1;
		attackState_reset_counter_max = -1;
		attackState = false;
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Enemy_GolemPaper::MoveOver()
{
	if (move_counter > 0)
	{
		move_counter--;
		if (lr == 0)
		{
			if (vx > -0xa00 / ts)
				vx -= 0x40 / ts;
		}
		else
		{
			if (vx < 0xa00 / ts)
				vx += 0x40 / ts;
		}
	}
	else
	{
		stateID = 5;
		moveinterval_counter = 60;
	}
}

std::shared_ptr<Entity> CreateCS_Enemy_GolemPaper()
{
	return std::make_shared<CS_Enemy_GolemPaper>();
}
