#include "CS_Enemy_GiantPignon2.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
CS_Enemy_GiantPignon2::CS_Enemy_GiantPignon2()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 8;
	hp_max = hp = 12;
	dropExp = 2;
	coyote_max = 0;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_GiantPignon2::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_GiantPignon2::Step()
{
	auto& ani_no = ani.image_index;
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	stateResist.Step();
	stateSplash.Step();
	if (shock_counter == 0)
	{
		if (cbRect.cbLeft)
		{
			lr = 1;
			vx = 0x200 / ts;
		}

		if (cbRect.cbRight)
		{
			lr = 0;
			vx = -0x200 / ts;
		}

		if (lr == 0)
			vx = -0x100 / ts;
		else
			vx = 0x100 / ts;
		ani.sprite_index = lr == 0 ? L"ls_giantpignon_move_l" : L"ls_giantpignon_move_r";
	}
	else
	{
		ani.sprite_index = lr == 0 ? L"ls_giantpignon_hurt_l" : L"ls_giantpignon_hurt_r";
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//ִ˶
	Entity::Step();
	//ͷ
	TurnBack();
	//һײ
	Entity::ClearCollisionResult();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_Enemy_GiantPignon2::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_giantpignon_stand_l" : L"ls_giantpignon_stand_r";
	ani.image_index = 0;
}

void CS_Enemy_GiantPignon2::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 1;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_GiantPignon2::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	vx = lr == 0 ? -1.0f : 1.0f;
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Enemy_GiantPignon2::TurnBack()
{
	if (!cbRect.cbBottom)
		return;
	//ǰǿյͷ
	float srcX = x;
	float srcY = y;
	if (lr == 0)
	{
		ignoreTrap = true;
		x -= 4;
		y += 4;
		Entity::ClearCollisionResult();
		Entity::Collision();
		//·ǿյͷ
		if (!cbRect.cbBottom || cbRect.onTrap)
		{
			lr = 1;
			vx = 0x200 / ts;
		}
	}
	else
	{
		ignoreTrap = true;
		x += 4;
		y += 4;
		Entity::ClearCollisionResult();
		Entity::Collision();
		//·ǿյͷ
		if (!cbRect.cbBottom || cbRect.onTrap)
		{
			lr = 0;
			vx = 0x200 / ts;
		}
	}
	//ԭ
	x = srcX;
	y = srcY;
	ignoreTrap = false;
}

std::shared_ptr<Entity> CreateCS_Enemy_GiantPignon2()
{
	return std::make_shared<CS_Enemy_GiantPignon2>();
}
