#include "CS_Enemy_CritterPurple.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_AmCritterPurple.h"

CS_Enemy_CritterPurple::CS_Enemy_CritterPurple()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.left = cbRect.right = 4;
	cbRect.top = 4;
	cbRect.bottom = 5;
	cbRect.fullWaterBlock = true;
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(1);
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(4);
	hp_max = hp = 10;
	dropExp = 4;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_CritterPurple::Init(std::weak_ptr<Entity> self)
{
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_CritterPurple::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateResist.apply_resistH = cbRect.cbBottom;
	stateResist.Step();
	stateSplash.Step();
	switch (act_no)
	{
	case 0:
		y += 0x600 / ts;
		act_no = 1;
		[[fallthrough]];
	case 1:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (act_wait >= 8 && x - 96 < wplayer->x && x + 96 > wplayer->x && y - 96 < wplayer->y && y + 32 > wplayer->y)
				{
					lr = x > wplayer->x ? 0 : 1;
					ani_no = 1;
				}
				else
				{
					if (act_wait < 8)
						++act_wait;
					ani_no = 0;
				}
				if (shock_counter > 0)
				{
					act_no = 2;
					ani_no = 0;
					act_wait = 0;
				}
				if (act_wait >= 8 && x - 48 < wplayer->x && x + 48 > wplayer->x && y - 96 < wplayer->y && y + 32 > wplayer->y)
				{
					act_no = 2;
					ani_no = 0;
					act_wait = 0;
				}
			}
		}
		break;
	case 2:
		if (++act_wait > 8)
		{
			act_no = 3;
			ani_no = 2;
			vy = -0x5FF / ts;
			gameFunc->PlaySound(L"CS_030_critter_jump");
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					lr = x > wplayer->x ? 0 : 1;
				}
			}
		}
		break;
	case 3:
		if (vy > 0x100 / ts)
		{
			tgt_y = y;
			act_no = 4;
			ani_no = 3;
			act_wait = 0;
			act_wait = 0;	// Duplicate line
		}
		break;
	case 4:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				lr = x < wplayer->x ? 1 : 0;
			}
		}
		++act_wait;
		if ((cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop) || act_wait > 60)
		{
			damage = 3;
			act_no = 5;
			ani_no = 2;
		}
		else
		{
			if (act_wait % 4 == 1)
				gameFunc->PlaySound(L"CS_109_critter_fly");

			if (cbRect.cbBottom)
				vy = -0x200 / ts;
			if (act_wait % 30 == 6)
			{
				if (gameFunc->GetPlayerDistance)
				{
					auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
					if (wplayer)
					{
						float dx = wplayer->x - x;
						float dy = wplayer->y - y;
						auto angle = XMConvertToDegrees(XMVectorGetX(XMVector2AngleBetweenVectors(XMVectorSet(1, 0, 0, 0), XMVectorSet(dx, dy, 0, 0))));
						if (dy < 0)
							angle = 360 - angle;
						angle += Random(-6, 6);
						float radian = angle * deg2rad;
						SetCS_AmCritterPurple(shared_from_this(), x, y, 3 * cosf(radian), 3 * sinf(radian));
						gameFunc->PlaySound(L"CS_039_em_fire");
					}
				}
			}
			if (++ani_wait > 0)
			{
				ani_wait = 0;
				++ani_no;
			}
			if (ani_no > 5)
				ani_no = 3;
		}
		break;
	case 5:
		if (cbRect.cbBottom)
		{
			damage = 2;
			vx = 0;
			act_wait = 0;
			ani_no = 0;
			act_no = 1;
			gameFunc->PlaySound(L"CS_023_thud");
		}
		break;
	}
	if (act_no != 4)
	{
		vy += 0x20 / ts;
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
	}
	else
	{
		if (y > tgt_y)
			vy -= 0x10 / ts;
		else
			vy += 0x10 / ts;

		if (vy > 0x200 / ts)
			vy = 0x200 / ts;
		if (vy < -0x200 / ts)
			vy = -0x200 / ts;

		if (vx > 0x200 / ts)
			vx = 0x200 / ts;
		if (vx < -0x200 / ts)
			vx = -0x200 / ts;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
	switch (ani_no)
	{
	case 0:
	case 1:
		ani.sprite_index = lr == 0 ? L"ls_critter_stand_l" : L"ls_critter_stand_r";
		ani.image_index = ani_no;
		break;
	case 2:
		ani.sprite_index = lr == 0 ? L"ls_critter_jump_l" : L"ls_critter_jump_r";
		ani.image_index = 0;
		break;
	case 3:
	case 4:
	case 5:
		ani.sprite_index = lr == 0 ? L"ls_critter_fly_l" : L"ls_critter_fly_r";
		ani.image_index = ani_no - 3;
		break;
	}
}

void CS_Enemy_CritterPurple::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_critter_stand_l" : L"ls_critter_stand_r";
}

void CS_Enemy_CritterPurple::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = damage;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_CritterPurple::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_051_enemy_hurt");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_CritterPurple()
{
	return std::make_shared<CS_Enemy_CritterPurple>();
}
