#include "CS_CurlyAni.h"

CS_CurlyAni::CS_CurlyAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(3);
	ani.hideLayerList.insert(4);
	ani.hideLayerList.insert(5);
	ani.hideLayerList.insert(6);
	ani.hideLayerList.insert(7);
	ani.hideLayerList.insert(8);
	ani.hideLayerList.insert(9);
	ani.hideLayerList.insert(10);
}

void CS_CurlyAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_CurlyAni::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	switch (stateID)
	{
	case 0://վ
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_CurlyAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	//ö
	switch (stateID)
	{
	case 0://վ
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_curly_stand_l" : L"mc_curly_stand_r";
		if (ud == -1)
			ani.sprite_index.append(L"u");
		break;
	case 1://·
		{
			animation_delay = true;
			if (lr == 0)
				vx = -animation_moveSpeed;
			else
				vx = animation_moveSpeed;
			const wchar_t* move = L"";
			if (ud == -1)
				move = lr == 0 ? L"mc_curly_move_lu" : L"mc_curly_move_ru";
			else
				move = lr == 0 ? L"mc_curly_move_l" : L"mc_curly_move_r";
			ani.sprite_index = move;
		}
		break;
	case 2://
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_curly_back_l" : L"mc_curly_back_r";
		break;
	case 10:
		vx = 0;
		ani.sprite_index = L"mc_curly_--";
		break;
	}
}

void CS_CurlyAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"back")
		SetState(2, lr);
	else if (stateName == L"--")
		SetState(10, lr);
	else if (stateName == L"topdraw")
		topDraw = lr != 0;
	else if (stateName == L"show_machinegun")
	{
		if (lr == 0)
			ani.hideLayerList.insert(5);
		else
			ani.hideLayerList.erase(5);
	}
}

std::shared_ptr<Entity> CreateCS_CurlyAni()
{
	return std::make_shared<CS_CurlyAni>();
}
