#include "CS_BubbleWall.h"
#include "CS_PeSmoke.h"
CS_BubbleWall::CS_BubbleWall()
{
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableMovePlatform = true;
	hp_max = hp = 1;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_bubblewall";
	cbRect.fullWaterBlock = true;
}

void CS_BubbleWall::Step()
{
	if (!PxaIsWater(GetMapPxa((int)(x / 16), (int)(y / 16))))
	{
		int out = 0;
		Hurt(std::weak_ptr<Entity>(), 127, 0, false, 0, 0, 0, &out);
	}
}

bool CS_BubbleWall::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	hp -= getDamage;
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_021_bubble");
		//
		SetCS_PeSmokeWater(shared_from_this(), x, y, 2);
		hp = 0;
		Destroy();
	}
	return true;
}

std::shared_ptr<Entity> CreateCS_BubbleWall()
{
	return std::make_shared<CS_BubbleWall>();
}
