#include "CS_Boss_TapScissorsClone.h"
#include "PeSmog.h"

CS_Boss_TapScissorsClone::CS_Boss_TapScissorsClone(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"mc_tap_scissors_d";
	cbRect.enableCbRect = true;
	cbRect.left = cbRect.right = 16;
	cbRect.top = 64;
	cbRect.bottom = 8;
	drawBeforeOtherEntity = true;
	speedDir = true;
}

void CS_Boss_TapScissorsClone::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	//Ч
	auto wlightTail = std::make_shared<PeLightTail>(shared_from_this(), 40, 32.0f);
	lightTail = wlightTail;
	gameFunc->SetEntity(shared_from_this(), wlightTail);
	Entity::Init(self);
}

void CS_Boss_TapScissorsClone::Step()
{
	stateGravity.Step();
	stateSplash.Step();
	//ǽ
	if (cbRect.cbLeft)
		vx = abs(vx);
	if (cbRect.cbRight)
		vx = -abs(vx);
	vy = 0xc00 / ts;
	//ʧ
	if (cbRect.cbBottom)
	{
		for (auto i = 0; i < 8; i++)
			SetPeSmog(shared_from_this(), x, y, 1, 1, (float)Random(0, 360));
		gameFunc->PlaySound(L"CS_012_block_destroy");
		Destroy();
		auto wlightTail = lightTail.lock();
		if (wlightTail)
			wlightTail->Leave();
	}
	srcVx = vx;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	vx = srcVx;
	//άб
	Entity::KeepOnSlopes();
	//
	ani.sprite_index = vy < 0 ? L"mc_tap_scissors_u" : L"mc_tap_scissors_d";
}

void CS_Boss_TapScissorsClone::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 10;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

void SetCS_Boss_TapScissorsClone(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_Boss_TapScissorsClone>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	parent->gameFunc->SetEntity(parent, am);
}
