#include "CS_Boss_Tap.h"
#include "CS_PeSmoke.h"
#include "PeSmog.h"
#include "CS_Boss_TapDmgRect.h"
#include "CS_AmWindShield.h"
#include "CS_AmTornado.h"
#include "CS_TapScissorsRain_Locater.h"
#include "CS_AmChainBat.h"
#include "CS_Boss_TapPress.h"
#include <random>
CS_Boss_Tap::CS_Boss_Tap()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"mc_tap_stand";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 16;
	cbRect.bottom = 8;
	cbRect.top = 32;
	hp_max = hp = 400;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
	//ùģʽ
	TapAttackMode mode[] =
	{
		TapAttackMode_Paper,
		TapAttackMode_Scissors,
		TapAttackMode_Rock,
	};
	for (auto& p : mode)
		attackModeList.push_back(p);
}

void CS_Boss_Tap::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	auto wdmgRect = std::make_shared<CS_Boss_TapDmgRect>(std::static_pointer_cast<CS_Boss_Tap>(shared_from_this()));
	dmgRect = wdmgRect;
	gameFunc->SetEntity(shared_from_this(), wdmgRect);
	Entity::Init(self);
}

void CS_Boss_Tap::Step()
{
	stateSplash.Step();
	switch (stateID)
	{
	case 0://
		break;
	case 1:
		ani.image_index = 0;
		vy += 0x20 / ts;
		if (drop_counter > 0)
		{
			drop_counter--;
			cbRect.enableCbRect = false;
			cbRect.enableSoild = false;
		}
		else
		{
			cbRect.enableCbRect = true;
			cbRect.enableSoild = true;
		}
		if (cbRect.enableSoild)
		{
			if (cbRect.cbBottom)
			{
				for (int i = 0; i < 4; i++)
				{
					auto pe = std::make_shared<CS_PeSmoke>();
					pe->x = x + Random(-12, 12);
					pe->y = y + Random(-12, 12);
					pe->vx = Random(-341, 341) / ts;
					pe->vy = Random(-0x600, 0) / ts;
					gameFunc->SetEntity(shared_from_this(), pe);
				}
				gameFunc->PlaySound(L"CS_026_quake");
				if (gameFunc->SetQuake)
					gameFunc->SetQuake(gameFunc->game, 30, 0);
				stateID = 0;
			}
		}
		//
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		if (vy < -0x5FF / ts)
			vy = -0x5FF / ts;
		break;
	case 2://ս
		if (attackModeList.empty())
		{
			//ģʽ
			for (auto i = 0; i < 2; i++)
				attackModeList.push_back((TapAttackMode)Random(0, 2));
		}
		else
		{
			//ȡһģʽ
			auto mode = attackModeList.front();
			attackModeList.pop_front();
			switch (mode)
			{
			case TapAttackMode_Paper:
				stateID = 3;
				break;
			case TapAttackMode_Scissors:
				stateID = 20;
				break;
			case TapAttackMode_Rock:
				stateID = 40;
				break;
			}
		}
		bAction = true;
		break;
	case 3://Ĺģʽ
		ani.sprite_index = L"mc_tap_paper";
		SetAttackRect(16, 16, 64, 8);
		action_timecounter = 16;
		windShield_count = 3;
		stateID = 4;
		break;
	case 4://תȴ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			//ѡһΪĿ
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					target = wplayer;
				}
			}
		}
		if (!target.expired())
		{
			//תĿ귽
			auto wtarget = target.lock();
			lr = x > wtarget->x ? 0 : 1;
			ani.sprite_index = lr == 0 ? L"mc_tap_paper_side_l" : L"mc_tap_paper_side_r";
			SetAttackRect(16, 16, 64, 8);
			action_timecounter = 30;//÷ʱ
			stateID = 5;
		}
		break;
	case 5://
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			ani.sprite_index = lr == 0 ? L"mc_tap_paper_slap_l" : L"mc_tap_paper_slap_r";
			//ߵ״̬µľο
			if (lr == 0)
				SetAttackRect(88, -8, 16, 8);
			else
				SetAttackRect(-8, 88, 16, 8);
			action_timecounter = 16;
			//ߵ
			stateID = 6;
			//ɷ
			auto am = std::make_shared<CS_AmWindShield>(shared_from_this(),true);
			am->x = x + (lr == 0 ? -32 : 32);
			am->y = y;
			gameFunc->SetEntity(shared_from_this(), am);
		}
		break;
	case 6://ߵͣ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			if (windShield_count > 0)
			{
				windShield_count--;
				stateID = 4;
			}
			else
			{
				stateID = 7;
			}
		}
		break;
	case 7://г
		if (lr == 0)
		{
			//ײ
			vx = -0xc00 / ts;
			if (cbRect.cbLeft)
				stateID = 8;
		}
		else
		{
			//ҳײ
			vx = 0xc00 / ts;
			if (cbRect.cbRight)
				stateID = 8;
		}
		walkSound += abs(vx);
		if (walkSound > 32)
		{
			walkSound -= 32;
			gameFunc->PlaySound(L"CS_107_block_move");
			SetPeSmog(shared_from_this(), x, y, 1, 1, lr == 0 ? 0 : 180.0f);
		}
		break;
	case 8://ײͣ
		stateID = 9;
		action_timecounter = 60;
		break;
	case 9:
		switch (action_timecounter)
		{
		case 30://ָվ
			ani.sprite_index = lr == 0 ? L"mc_tap_paper_side_l" : L"mc_tap_paper_side_r";
			SetAttackRect(16, 16, 64, 8);
			break;
		case 20:
			ani.sprite_index = L"mc_tap_paper";
			SetAttackRect(16, 16, 64, 8);
			break;
		case 10://ת
			lr = lr == 0 ? 1 : 0;
			ani.sprite_index = lr == 0 ? L"mc_tap_paper_side_l" : L"mc_tap_paper_side_r";
			SetAttackRect(16, 16, 64, 8);
			break;
		}
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			ani.sprite_index = lr == 0 ? L"mc_tap_paper_tornado_ready_l" : L"mc_tap_paper_tornado_ready_r";
			if(lr == 0)
				SetAttackRect(32, 8, 40, 8);
			else
				SetAttackRect(8, 32, 40, 8);
			action_timecounter = 30;
			stateID = 10;
		}	
		break;
	case 10://׼
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			ani.sprite_index = lr == 0 ? L"mc_tap_paper_tornado_hand_l" : L"mc_tap_paper_tornado_hand_r";
			if (lr == 0)
				SetAttackRect(32, 16, 40, 8);
			else
				SetAttackRect(16, 32, 40, 8);
			//
			auto am = std::make_shared<CS_AmTornado>(shared_from_this());
			am->x = x;
			am->y = y;
			gameFunc->SetEntity(shared_from_this(), am);
			action_timecounter = 30;
			stateID = 11;
		}
		break;
	case 11://罩ֱʱ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			//ָ
			ani.sprite_index = L"mc_tap_paper";
			SetAttackRect(16, 16, 64, 8);
			action_timecounter = 30;
			stateID = 12;
		}
		break;
	case 12://ͣʱ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 2;//һģʽ
		break;
	case 20://Ĺģʽ
		ani.sprite_index = L"mc_tap_scissors";
		SetAttackRect(16, 16, 64, 8);
		action_timecounter = 30;
		stateID = 21;
		break;
	case 21://ɼ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			SetPeSmog(shared_from_this(), x, y, 8);
			ani.sprite_index = L"mc_tap_scissors_u";
			action_timecounter = 30;
			stateID = 22;
		}
		break;
	case 22://ֱĻ֮
		cbRect.enableCbRect = false;
		cbRect.enableSoild = false;
		vy = -0x800 / ts;
		vx = 0;
		if (y < -16)
		{
			vy = 0;
			action_timecounter = 30;
			stateID = 23;
		}
		break;
	case 23://׼ʱ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			//ü
			auto& roomRes = *gameFunc->GetLoadedEntity(gameFunc->entityRes);
			std::list<std::shared_ptr<Entity>>* pLs = nullptr;
			for (auto& p : roomRes)
			{
				if (p.first->layerType == 0)
				{
					pLs = &p.second.Ls;
					break;
				}
			}
			std::vector<std::shared_ptr<Entity>> arr;
			if (pLs)
			{
				for (auto& e : *pLs)
					if (e->el.name == CS_TAPSCISSORSRAIN_LOCATER_CREATENAME)
						arr.push_back(e);
			}
			std::random_device rd;
			std::mt19937 gen(rd());
			std::shuffle(arr.begin(), arr.end(), gen);

			scissorsFallLocation.clear();
			for (auto& e : arr)
			{
				e->SetState(L"fallscissors", (int)scissorsFallLocation.size() * 20);
				scissorsFallLocation.push_back(e->x);
			}
			action_timecounter = ((int)scissorsFallLocation.size() + 1) * 20 + 30;
			stateID = 24;
		}
		break;
	case 24://ȴ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			//ɼһ
			ani.sprite_index = L"mc_tap_scissors_d";
			//ѡһλ
			int index = Random(0, (int)scissorsFallLocation.size() - 1);
			x = scissorsFallLocation[index];
			y = -16;
			//Ч
			auto wlightTail = std::make_shared<PeLightTail>(shared_from_this(), 40, 32.0f);
			lightTail = wlightTail;
			gameFunc->SetEntity(shared_from_this(), wlightTail);
			//
			cbRect.enableCbRect = true;
			cbRect.enableSoild = true;
			stateID = 25;
		}
		break;
	case 25://ȴ
		vx = 0;
		vy = 0xc00 / ts;
		if (cbRect.cbBottom)
		{
			auto wlightTail = lightTail.lock();
			if (wlightTail)
				wlightTail->Leave();
			lightTail.reset();
			//
			SetPeSmog(shared_from_this(), x, y, 8);
			gameFunc->PlaySound(L"CS_012_block_destroy");
			ani.sprite_index = L"mc_tap_scissors";
			SetAttackRect(16, 16, 64, 8);
			action_timecounter = 30;
			stateID = 26;
		}
		break;
	case 26://ֱʱ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			//ѡһΪĿ
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					target = wplayer;
					lr = x > wplayer->x ? 0 : 1;
					ani.sprite_index = lr == 0 ? L"mc_tap_scissors_slash_ready_l" : L"mc_tap_scissors_slash_ready_r";
					action_timecounter = 30;
					slash_count = 2;
					bSetSlashDir = true;
					stateID = 27;
				}
			}
		}
		break;
	case 27://ģʽ2
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			if (bSetSlashDir)
				bSetSlashDir = false;
			else
				lr = lr == 0 ? 1 : 0;
			//Ч
			auto wlightTail = std::make_shared<PeLightTail>(shared_from_this(), 40, 120.0f);
			lightTail = wlightTail;
			gameFunc->SetEntity(shared_from_this(), wlightTail);
			gameFunc->PlaySound(L"CS_106");
			ani.sprite_index = lr == 0 ? L"mc_tap_scissors_slash_l" : L"mc_tap_scissors_slash_r";
			stateID = 28;
		}
		if (action_timecounter / 2 % 2 == 0)
		{
			shader.usingShader = false;
		}
		else
		{
			shader.usingShader = true;
			shader.ps = shader.vs = L"flash";
		}
		break;
	case 28://ն1
		vx = lr == 0 ? -0x1800 / ts : 0x1800 / ts;
		if (lr == 0 && cbRect.cbLeft || lr != 0 && cbRect.cbRight)
		{
			ani.sprite_index = lr == 0 ? L"mc_tap_scissors_slash_ready_l" : L"mc_tap_scissors_slash_ready_r";
			action_timecounter = 30;
			if (slash_count > 0)
			{
				slash_count--;
				stateID = 27;
			}
			else
			{
				action_timecounter = 30;
				stateID = 29;
			}
			auto wlightTail = lightTail.lock();
			if (wlightTail)
				wlightTail->Leave();
			lightTail.reset();
		}
		break;
	case 29://ն
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			ani.sprite_index = L"mc_tap_scissors";
			SetAttackRect(16, 16, 64, 8);
			action_timecounter = 30;
			stateID = 30;
		}
		break;
	case 30://һģʽ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 2;
		break;
	case 40://ʯͷĹģʽ
		ani.sprite_index = L"mc_tap_rock";
		SetAttackRect(16, 16, 32, 8);
		hammerblow_count = 2;
		action_timecounter = 30;
		stateID = 41;
		break;
	case 41://Ԥ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			action_timecounter = 40;//ʱ
			stateID = 42;
		}
		break;
	case 42://
		cbRect.enableCbRect = false;
		cbRect.enableSoild = false;
		vx = 0;
		vy = -0x800 / ts;
		if (action_timecounter > 0)
		{
			action_timecounter--;
		}
		else
		{
			vy = 0;
			//ѡһΪĿ
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					cbRect.enableCbRect = true;
					cbRect.enableSoild = true;
					target = wplayer;
					stateID = 43;
				}
					
			}		
		}
		break;
	case 43://
		if (target.expired())
		{
			//ѡһΪĿ
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
					target = wplayer;
			}
		}
		else
		{
			auto wtarget = target.lock();
			if (abs(x - wtarget->x) >= 4)
			{
				if (x > wtarget->x)
				{
					vx = -0x800 / ts;
					ani.sprite_index = L"mc_tap_rock_l";
					SetAttackRect(24, 24, 32, 8);
				}
				else
				{
					vx = 0x800 / ts;
					ani.sprite_index = L"mc_tap_rock_r";
					SetAttackRect(24, 24, 32, 8);
				}
			}
			else
			{
				//
				ani.sprite_index = L"mc_tap_rock_d";
				SetAttackRect(16, 16, 40, 8);
				action_timecounter = 60;
				stateID = 44;
			}
		}
		break;
	case 44://
		last_x = x;
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter > 20)
		{
			if (target.expired())
			{
				//Ŀ궪ʧ
				stateID = 43;
			}
			else
			{
				auto wtarget = target.lock();
				x = wtarget->x;
				vx = 0;
				vy = 0;
			}
		}
		if (action_timecounter == 0)
			stateID = 45;
		break;
	case 45://´
		vy = 0x1000 / ts;
		vx = 0;
		if (cbRect.cbBottom)
		{
			int srcLr = lr;
			lr = 0;
			//С
			auto am = std::make_shared<CS_AmWindShield>(shared_from_this());
			am->x = x + (lr == 0 ? -32 : 32);
			am->y = y;
			gameFunc->SetEntity(shared_from_this(), am);
			lr = 1;
			am = std::make_shared<CS_AmWindShield>(shared_from_this());
			am->x = x + (lr == 0 ? -32 : 32);
			am->y = y;
			gameFunc->SetEntity(shared_from_this(), am);
			lr = srcLr;
			for (int i = 0; i < 4; i++)
			{
				auto pe = std::make_shared<CS_PeSmoke>();
				pe->x = x + Random(-12, 12);
				pe->y = y + Random(-12, 12);
				pe->vx = Random(-341, 341) / ts;
				pe->vy = Random(-0x600, 0) / ts;
				gameFunc->SetEntity(shared_from_this(), pe);
			}
			gameFunc->PlaySound(L"CS_026_quake");
			if (gameFunc->SetQuake)
				gameFunc->SetQuake(gameFunc->game, 30, 0);
			action_timecounter = 30;
			stateID = 46;
		}
		break;
	case 46://´Ľֱʱ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			ani.sprite_index = L"mc_tap_rock";
			SetAttackRect(16, 16, 32, 8);
			if (hammerblow_count > 0)
			{
				hammerblow_count--;
				stateID = 41;
			}
			else
			{
				stateID = 47;
			}
		}
		break;
	case 47://ʯͷĹģʽ2 ѹ·
		action_timecounter = 60;
		stateID = 48;
		break;
	case 48:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			if (chainBat.expired())
			{
				//ѡһΪĿ
				if (gameFunc->GetPlayerDistance)
				{
					auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
					if (wplayer)
					{
						cbRect.enableCbRect = true;
						cbRect.enableSoild = true;
						target = wplayer;
						//
						auto wchainBat = std::make_shared<CS_AmChainBat>(wplayer);
						chainBat = wchainBat;
						wchainBat->x = x;
						wchainBat->y = y;
						gameFunc->SetEntity(shared_from_this(), wchainBat);
						//
						SetPeSmog(shared_from_this(), x, y, 3);
					}

				}
			}
		}
		if (y < 0)
		{
			gameFunc->PlaySound(L"CS_026_quake");
			gameFunc->SetQuake(gameFunc->game, 30, 0);
			action_timecounter = 8 * 60;
			stateID = 49;
		}
		cbRect.enableCbRect = false;
		cbRect.enableSoild = false;
		vx = 0;
		vy = -0x800 / ts;
		break;
	case 49://һЩʯ
		{
			auto& roomRes = *gameFunc->GetLoadedEntity(gameFunc->entityRes);
			std::list<std::shared_ptr<Entity>>* pLs = nullptr;
			for (auto& p : roomRes)
			{
				if (p.first->layerType == 0)
				{
					pLs = &p.second.Ls;
					break;
				}
			}
			std::vector<std::shared_ptr<Entity>> arr;
			if (pLs)
			{
				for (auto& e : *pLs)
					if (e->el.name == CS_TAPSCISSORSRAIN_LOCATER_CREATENAME)
						arr.push_back(e);
			}
			std::random_device rd;
			std::mt19937 gen(rd());
			std::shuffle(arr.begin(), arr.end(), gen);
			int i = 0;
			for (auto& e : arr)
			{
				if (i >= 6)
					break;
				e->SetState(L"fallrock", (i + 1) * 60);
				i++;
			}
			stateID = 50;
		}
		break;
	case 50://ȴʯ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			auto wchainBat = chainBat.lock();
			if (wchainBat)
			{
				x = wchainBat->x;
				y = -32;
				vy = 0;
			}
			else
			{
				//ѡһΪĿ
				if (gameFunc->GetPlayerDistance)
				{
					auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
					if (wplayer)
					{
						x = wplayer->x;
						y = -32;
						vy = 0;
					}
				}
			}
			//ѹ·
			ani.sprite_index = L"mc_tap_rock_d";
			SetAttackRect(16, 16, 40, 8);
			auto wpress = std::make_shared<CS_Boss_TapPress>(shared_from_this());
			press = wpress;
			wpress->x = x;
			wpress->y = y;
			gameFunc->SetEntity(shared_from_this(), wpress);
			stateID = 51;
		}
		break;
	case 51://ȴѹ·
		{
			auto wpress = press.lock();
			if (wpress && wpress->inUsing)
			{
				x = wpress->x;
				last_x = wpress->last_x;
				y = wpress->y - wpress->cbRect.top;
				last_y = wpress->last_y - wpress->cbRect.top;
				if (wpress->cbRect.cbBottom)
				{
					stateID = 0;
				}
				cbRect.enableCbRect = false;
				cbRect.enableSoild = false;
				cbRect.ignoreMovePlatform = true;
			}
			else
			{
				//ƻ
				cbRect.enableCbRect = true;
				cbRect.enableSoild = true;
				cbRect.ignoreMovePlatform = false;
				Entity::ClearCollisionResult();
				stateID = 52;
			}
		}
		break;
	case 52://ѹ
		vy = 0x1000 / ts;
		vx = 0;
		if (cbRect.cbBottom)
		{
			int srcLr = lr;
			lr = 0;
			//С
			auto am = std::make_shared<CS_AmWindShield>(shared_from_this());
			am->x = x + (lr == 0 ? -32 : 32);
			am->y = y;
			gameFunc->SetEntity(shared_from_this(), am);
			lr = 1;
			am = std::make_shared<CS_AmWindShield>(shared_from_this());
			am->x = x + (lr == 0 ? -32 : 32);
			am->y = y;
			gameFunc->SetEntity(shared_from_this(), am);
			//Ӵ
			auto wchainBat = chainBat.lock();
			if (wchainBat)
				wchainBat->SetState(L"release", 0);
			lr = srcLr;
			for (int i = 0; i < 4; i++)
			{
				auto pe = std::make_shared<CS_PeSmoke>();
				pe->x = x + Random(-12, 12);
				pe->y = y + Random(-12, 12);
				pe->vx = Random(-341, 341) / ts;
				pe->vy = Random(-0x600, 0) / ts;
				gameFunc->SetEntity(shared_from_this(), pe);
			}
			gameFunc->PlaySound(L"CS_026_quake");
			if (gameFunc->SetQuake)
				gameFunc->SetQuake(gameFunc->game, 30, 0);
			action_timecounter = 30;
			stateID = 53;
		}
		break;
	case 53://ֱʱ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			ani.sprite_index = L"mc_tap_rock";
			SetAttackRect(16, 16, 32, 8);
			stateID = 54;
		}
		break;
	case 54://һģʽ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 2;
		break;
	case 100://
		ani.sprite_index = L"mc_tap_defeated";
		stateGravity.State();
		if (abs(vx) < 0.001f)
			vx = 0;
		else
			vx /= 1.05f;
		break;
	}
	srcVx = vx;
	//һײ
	Entity::ClearCollisionResult();
	switch (stateID)
	{
	case 44:
	case 51:
		break;
	default:
		//ִ˶
		Entity::Step();
		break;
	}
	//ִײ
	Entity::Collision();
	vx = srcVx;
	//άб
	Entity::KeepOnSlopes();
	//dmgRect
	auto wdmgRect = dmgRect.lock();
	if (wdmgRect)
	{
		wdmgRect->x = x;
		wdmgRect->y = y;
		wdmgRect->lr = lr;
	}
}

void CS_Boss_Tap::SetState(int stateID, int lr)
{
	this->lr = lr;
	if (stateID < 1000)
	{
		this->stateID = stateID;
		switch (stateID)
		{
		case 0:
			ani.sprite_index = L"mc_tap_stand";
			return;
		case 2://ս
			return;
		}
	}
	else
	{
		this->stateID = 1;
		drop_counter = stateID - 1000;
		cbRect.enableCbRect = false;
		cbRect.enableSoild = false;
		//һײ
		Entity::ClearCollisionResult();
	}
}

void CS_Boss_Tap::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal_look")
	{
		ani.hideLayerList.insert(0);
		ani.hideLayerList.insert(1);
		ani.hideLayerList.insert(2);
		ani.hideLayerList.insert(3);
	}
	else if (stateName == L"left_look")
	{
		ani.hideLayerList.insert(0);
		ani.hideLayerList.insert(1);
		ani.hideLayerList.insert(2);
		ani.hideLayerList.erase(3);
	}
	else if (stateName == L"right_look")
	{
		ani.hideLayerList.insert(0);
		ani.hideLayerList.insert(1);
		ani.hideLayerList.erase(2);
		ani.hideLayerList.insert(3);
	}
	else if (stateName == L"down_look")
	{
		ani.hideLayerList.insert(0);
		ani.hideLayerList.erase(1);
		ani.hideLayerList.insert(2);
		ani.hideLayerList.insert(3);
	}
	else if (stateName == L"dead_fish_eyes")
	{
		ani.hideLayerList.erase(0);
		ani.hideLayerList.insert(1);
		ani.hideLayerList.insert(2);
		ani.hideLayerList.insert(3);
	}
	else if (stateName == L"fight")
	{
		SetState(2, lr);
	}
}

bool CS_Boss_Tap::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (bHurtBlock)
		return false;
	if (!bAction)
		return false;
	if (getDamage < 5)
	{
		*outRealDamage = 0;
		return true;
	}
	if (hp == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		stateID = 100;
		damage_reset_counter = -1;
		attackState_reset_counter_max = -1;
		attackState = false;
		auto wdmgRect = dmgRect.lock();
		if (wdmgRect)
			wdmgRect->Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Boss_Tap::Destroy()
{
	auto wdmgRect = dmgRect.lock();
	if (wdmgRect)
		wdmgRect->Destroy();
	ActionEntity::Destroy();
}

void CS_Boss_Tap::SetAttackRect(float left, float right, float top, float bottom)
{
	auto wdmgRect = dmgRect.lock();
	if (wdmgRect)
	{
		wdmgRect->cbRect.left = left;
		wdmgRect->cbRect.right = right;
		wdmgRect->cbRect.top = top;
		wdmgRect->cbRect.bottom = bottom;
	}
}

std::shared_ptr<Entity> CreateCS_Boss_Tap()
{
	return std::make_shared<CS_Boss_Tap>();
}
