#include "CS_Boss_Puu.h"
#include "CS_PuuBubble_Empty.h"
#include "CS_PuuBubble_SoapA.h"
#include "CS_PuuBubble_SoapB.h"
#include "CS_PuuBubble_SoapC.h"
#include "CS_PeSmoke.h"
#include "CS_Boss_GroupHpBar.h"
CS_Boss_Puu::CS_Boss_Puu()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 14;
	cbRect.top = 15;
	cbRect.bottom = 8;
	hp_max = hp = 300;
	ani.hideLayerList.insert(1);
	ani.hideLayerList.insert(2);
	drawBeforeOtherEntity = true;

	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Boss_Puu::Init(std::weak_ptr<Entity> self)
{
	stateResist.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Boss_Puu::Step()
{
	if (bFindGroupHpBar)
	{
		bFindGroupHpBar = false;
		//ѰҹѪ
		if (gameFunc->GetLoadedEntity)
		{
			auto& allRes = *gameFunc->GetLoadedEntity(gameFunc->entityRes);
			for (auto& p : allRes)
			{
				if (p.first->layerType == 0)
				{
					for (auto& e : p.second.Ls)
					{
						if (e->el.name == CS_BOSS_GROUPHPBAR_CREATENAME)
						{
							groupHpBar = e;
							break;
						}
					}
					break;
				}
			}
		}
	}
	if (caught_counter > 0)
	{
		caught_counter--;
		stateResist.Step();
		if (caught_counter == 0)
		{
			//Ŀ׳
			auto wcaughtTarget = caughtTarget.lock();
			if (wcaughtTarget)
			{
				float throwSpeed = 0x800 / ts;
				wcaughtTarget->hide = false;
				wcaughtTarget->vx = lr == 0 ? -throwSpeed : throwSpeed;
				wcaughtTarget->vy = -0x500 / ts;
			}
			//ýֱʱ
			action_timecounter = 60;
		}
	}
	else
	{
		if (action_timecounter > 0)
		{
			action_timecounter--;
			ani.sprite_index = lr == 0 ? L"mc_puu_jump_l" : L"mc_puu_jump_r";
		}
		else
		{
			switch (stateID)
			{
			case 0:
				//Է
				if (gameFunc->GetPlayerDistance)
				{
					auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
					if (wplayer)
						lr = x > wplayer->x ? 0 : 1;
				}
				bubbleCloud_counter = Random(30, 70);
				stateID = 1;
				break;
			case 1://ơ״̬1
				ani.sprite_index = lr == 0 ? L"mc_puu_openmouth_l" : L"mc_puu_openmouth_r";
				if (bubbleCloud_counter > 0)
				{
					bubbleCloud_counter--;
					if (bubbleCloud_counter % 2 == 0)
						ShootBubble();
				}
				else
				{
					stateID = 2;
					runJump_counter = 3;//ƶԾ
				}
				break;
			case 2://Ŀ꡾״̬2
				if (runJump_counter > 0)
				{
					runJump_counter--;
					if (Random(0, 10) >= 3)
					{
						//Ծ
						jump_counter = 30;
						stateID = 4;
					}
					else
					{
						//ƶ
						//ƶʱ
						run_counter = Random(60, 120);
						stateID = 3;
					}
					//Է
					if (gameFunc->GetPlayerDistance)
					{
						auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
						if (wplayer)
							lr = x > wplayer->x ? 0 : 1;
					}
				}
				else
				{
					stateID = 6;
				}
				break;
			case 3://ƶ
				if (run_counter > 0)
					run_counter--;
				else
				{
					stateID = 5;
					runJumpInterval_counter = 30;//ƶԾϢʱ
				}
				if (lr == 0)
					vx -= 0x20 / ts;
				else
					vx += 0x20 / ts;
				ani.sprite_index = lr == 0 ? L"mc_puu_move_l" : L"mc_puu_move_r";
				break;
			case 4://Ծ
				ani.sprite_index = lr == 0 ? L"mc_puu_jump_l" : L"mc_puu_jump_r";
				if (jump_counter > 0)
				{
					jump_counter--;
					ani.sprite_index = lr == 0 ? L"mc_puu_landing_l" : L"mc_puu_landing_r";
					if (jump_counter == 0)
					{
						vy = -0x400 / ts;
						float vxSpeed = Random(0x400, 0x800) / ts;
						vx = lr == 0 ? -vxSpeed : vxSpeed;
					}
				}
				else
				{
					if (cbRect.cbBottom)
					{
						stateID = 5;
						runJumpInterval_counter = 30;//ƶԾϢʱ
					}
				}
				break;
			case 5://ƶ/Ծʱ
				if (runJumpInterval_counter > 0)
					runJumpInterval_counter--;
				else
					stateID = 2;//ص״̬2
				ani.sprite_index = lr == 0 ? L"mc_puu_stand_l" : L"mc_puu_stand_r";
				vx = 0;
				break;
			case 6://״̬3
				stateID = 0;
				break;
			case 7://
				ani.sprite_index = lr == 0 ? L"mc_puu_defeated_l" : L"mc_puu_defeated_r";
				stateResist.State();
				break;
			}
		}
	}
	//ٶ
	if (vx < -0x600 / ts)
		vx = -0x600 / ts;
	if (vx > 0x400 / ts)
		vx = 0x400 / ts;
	vy += 0x20 / ts;
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_Boss_Puu::SetState(int stateID, int lr)
{
	this->stateID = stateID;
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"mc_puu_stand_l" : L"mc_puu_stand_r";
}

void CS_Boss_Puu::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (hp <= 0)
		return;
	auto wdst = dst.lock();
	if (wdst->type == 1 && caught_counter == 0 && action_timecounter == 0 && (stateID == 3 || stateID == 4))
	{
		//
		*outDamage = 10;
		auto wcaught = wdst->BeginCaught(shared_from_this()).lock();
		if (wcaught)
		{
			wdst->hide = true;
			caughtTarget = dst;
			ani.sprite_index = lr == 0 ? L"mc_puu_caught_l" : L"mc_puu_caught_r";
			caught_counter = 120;
		}
	}
	else
	{
		*outDamage = 5;
		auto wdst = dst.lock();
		if (wdst)
		{
			if (wdst->lr == 0)
			{
				*outAngle = 315;
			}
			else
			{
				*outAngle = 225;
			}
		}
		*outTakedown = true;
		*outElemType = 0;
		*outShockForce = 0x200 / ts;
		*outHeavy = 2;
	}
}

bool CS_Boss_Puu::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (caught_counter > 0)
		return false;
	if (getDamage == 0)
		return false;
	if (hp == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	//groupHpBar¼˺
	auto wgroupHpBar = groupHpBar.lock();
	if (wgroupHpBar)
	{
		int out;
		int dmg = getDamage;
		if (hp < 0)
			dmg += hp;
		wgroupHpBar->Hurt(src, dmg, angle, bTakedown, elemType, shockForce, heavy, &out);
	}
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_051_enemy_hurt");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		stateID = 7;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Boss_Puu::ShootBubble()
{
	float radian;
	if (lr == 0)
		radian = Random(180 + 15, 270 - 15) * deg2rad;
	else
		radian = Random(270 + 15, 360 - 15) * deg2rad;
	float shootSpeed = Random(0x200, 0x800) / ts;
	float shootVx = shootSpeed * cosf(radian);
	float shootVy = shootSpeed * sinf(radian);
	int type = Random(0, 100);
	gameFunc->PlaySound(L"CS_021_bubble");
	float dx = lr == 0 ? -4.0f : 4.0f;
	if (type <= 80)
		SetCS_PuuBubble_Empty(shared_from_this(), x + dx, y, shootVx, shootVy);
	else if (type <= 90)
		SetCS_PuuBubble_SoapA(shared_from_this(), x + dx, y, shootVx, shootVy);
	else if (type <= 95)
		SetCS_PuuBubble_SoapB(shared_from_this(), x + dx, y, shootVx, shootVy);
	else
		SetCS_PuuBubble_SoapC(shared_from_this(), x + dx, y, shootVx, shootVy);
}

std::shared_ptr<Entity> CreateCS_Boss_Puu()
{
	return std::make_shared<CS_Boss_Puu>();
}
