#include "CS_Boss_MonsterX.h"
#include <algorithm>
#include <random>
#include "CS_AmMonsterXPaw.h"
#include "CS_AmMonsterXPawD.h"
#include "CS_AmElectricCircle.h"
#include "CS_AmEMP.h"
#include "CS_AmNekoPunch.h"

CS_Boss_MonsterX::CS_Boss_MonsterX()
{
	type = 2;
	hp = hp_max = 1000;
	//ùģʽ
	MonsterXAttackMode mode[] = 
	{
		MonsterXAttackMode_PAW,
		MonsterXAttackMode_MISSILE,
		MonsterXAttackMode_LASER,
	};
	for (auto& p : mode)
		attackModeList.push_back(p);
}

void CS_Boss_MonsterX::Init(std::weak_ptr<Entity> self)
{
	if (el.arg.length() && ParseInts(el.arg.c_str(), argbuff))
	{
		if (argbuff.size() == 4)
		{
			zoneL = argbuff[0];
			zoneR = argbuff[1];
			zoneU = argbuff[2];
			zoneD = argbuff[3];
		}
	}
	//ڶ׶Ҫ¼
	secondFormEvent = el.arg2;
	screenShatteredEvent = el.arg3;
	//ʼ۾
	auto weyeL = std::make_shared<CS_Boss_MonsterXEye>(shared_from_this());
	eyeL = weyeL;
	weyeL->lr = 0;
	auto weyeR = std::make_shared<CS_Boss_MonsterXEye>(shared_from_this());
	eyeR = weyeR;
	weyeR->lr = 1;
	//۾λ
	int centerX = (zoneL + zoneR) / 2;
	int centerY = (zoneU + zoneD) / 2;
	weyeL->x = (centerX - 2)* 16.0f + 8.0f;
	weyeL->y = centerY * 16.0f + 8.0f;
	weyeR->x = (centerX + 2) * 16.0f + 8.0f;
	weyeR->y = centerY * 16.0f + 8.0f;
	gameFunc->SetEntity(shared_from_this(), weyeL);
	gameFunc->SetEntity(shared_from_this(), weyeR);
	Entity::Init(self);
}

void CS_Boss_MonsterX::Step()
{
	switch (stateID)
	{
	case 0://bossδ
		break;
	case 1://boss
		if (attackModeList.empty())
		{
			switch (level)
			{
			case 0:
				//ѡ񹥻ģʽ
				if (hp <= 500)
				{
					//ڶ׶¼
					if (gameFunc->StartEvent && secondFormEvent.length())
						gameFunc->StartEvent(gameFunc->gameScript, secondFormEvent.c_str(), L"tBoot");
					stateID = 0;
				}
				else
				{
					//ѡһģʽ
					MonsterXAttackMode mode[] =
					{
						MonsterXAttackMode_PAW,
						MonsterXAttackMode_MISSILE,
						MonsterXAttackMode_LASER,
					};
					int targetMode = Random(0, _countof(mode) - 1);
					attackModeList.push_back(mode[targetMode]);
				}
				break;
			case 1:
				//ѡһģʽ
				MonsterXAttackMode mode[] =
				{
					MonsterXAttackMode_ANGRY,
					MonsterXAttackMode_BOMB,
				};
				int targetMode = Random(0, _countof(mode) - 1);
				attackModeList.push_back(mode[targetMode]);
				break;
			}
		}
		else
		{
			//ȡһģʽ
			auto mode = attackModeList.front();
			attackModeList.pop_front();
			switch (mode)
			{
			case MonsterXAttackMode_PAW:
				stateID = 10;
				break;
			case MonsterXAttackMode_MISSILE:
				stateID = 20;
				break;
			case MonsterXAttackMode_LASER:
				stateID = 30;
				break;
			case MonsterXAttackMode_ANGRY:
				stateID = 100;
				break;
			case MonsterXAttackMode_BOMB:
				stateID = 110;
				break;
			}
		}
		break;
	case 10://צģʽ
		pawAttackCount = 3;//ù
		stateID = 11;
		break;
	case 11:
		if (pawAttackCount > 0)
		{
			pawAttackCount--;
			//ù
			auto lr = Random(0, 1);
			auto am = std::make_shared<CS_AmMonsterXPaw>(shared_from_this());
			am->y = (zoneD - 1) * 16.0f;
			am->x = (lr == 0 ? zoneR : zoneL) * 16.0f;
			am->SetState(0, lr);
			gameFunc->SetEntity(shared_from_this(), am);
			//һʱ
			action_timecounter = 120;
			stateID = 12;
		}
		else
		{
			//ȥצģʽ2
			stateID = 13;
		}
		break;
	case 12:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 11;
		break;
	case 13://Ĺģʽ
		pawAttackCount = 6;//ù
		stateID = 14;
		break;
	case 14:
		if (pawAttackCount > 0)
		{
			pawAttackCount--;
			if (pawAttackCount == 0)
			{
				//ù
				auto lr = 0;
				auto am = std::make_shared<CS_AmMonsterXPaw>(shared_from_this());
				am->y = (zoneD - 1) * 16.0f;
				am->x = zoneR * 16.0f;
				am->SetState(0, lr);
				gameFunc->SetEntity(shared_from_this(), am);
				lr = 1;
				am = std::make_shared<CS_AmMonsterXPaw>(shared_from_this());
				am->y = (zoneD - 1) * 16.0f;
				am->x = zoneL * 16.0f;
				am->SetState(0, lr);
				gameFunc->SetEntity(shared_from_this(), am);
			}
			else
			{
				//ù
				if (gameFunc->GetPlayerDistance)
				{
					auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
					if (wplayer)
					{
						//¹
						auto am = std::make_shared<CS_AmMonsterXPawD>(shared_from_this());
						am->y = (zoneU + 3) * 16.0f;
						am->x = std::clamp(wplayer->x, (zoneL + 1) * 16.0f, (zoneR - 1) * 16.0f);
						gameFunc->SetEntity(shared_from_this(), am);
					}
				}
			}
			//һʱ
			action_timecounter = 30;
			stateID = 15;
		}
		else
		{
			action_timecounter = 120;
			stateID = 16;
		}
		break;
	case 15:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 14;
		break;
	case 16://ȥһģʽ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 1;
		break;
	case 20://͸ߵ﹥ģʽ
		{
			//ɾ֮ǰеĵ
			for (auto& e : fishMissileList)
			{
				auto we = e.lock();
				if (we)
					we->Destroy();
			}
			fishMissileList.clear();
			for (auto& e : pawCoreList)
			{
				auto we = e.lock();
				if (we)
					we->Destroy();
			}
			pawCoreList.clear();
			//ڶ4λɵ
			std::set<int> xPosSet;
			while (xPosSet.size() < 4)
			{
				int i = Random(zoneL, zoneR);
				//ʹɼ
				if (xPosSet.find(i + 1) != xPosSet.end())
					continue;
				if (xPosSet.find(i - 1) != xPosSet.end())
					continue;
				xPosSet.insert(i);
			}
			for (auto& i : xPosSet)
			{
				auto am = std::make_shared<CS_AmFishMissileBase>();
				fishMissileList.push_back(am);
				am->x = i * 16.0f;
				am->y = zoneU * 16.0f;
				am->lr = am->x > (zoneL + zoneR) * 16.0f / 2 ? 0 : 1;
				am->SetState(0, am->lr);
				am->attackParent = weak_from_this();
				gameFunc->SetEntity(shared_from_this(), am);
				am->SetState(L"set_smog", am->lr);
			}
			//·4Һ
			xPosSet.clear();
			while (xPosSet.size() < 4)
				xPosSet.insert(Random(zoneL + 1, zoneR - 1));
			for (auto& i : xPosSet)
			{
				auto am = std::make_shared<CS_AmPawcore>();
				pawCoreList.push_back(am);
				am->x = i * 16.0f;
				am->y = Random(zoneU + 1, zoneU + 4) * 16.0f;
				am->attackParent = weak_from_this();
				gameFunc->SetEntity(shared_from_this(), am);
				am->SetState(L"set_smog", am->lr);
			}
		}
		action_timecounter = 120;
		stateID = 21;
		break;
	case 21://۾
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			stateID = 22;
		}
		break;
	case 22://Ƿƻ
		fishMissileList.remove_if([](auto& e)
		{
			return e.expired();
		});
		pawCoreList.remove_if([](auto &e)
		{
			return e.expired();
		});
		if (pawCoreList.empty() && fishMissileList.empty())
		{
			action_timecounter = 120;
			stateID = 23;
		}
		break;
	case 23://ü
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			xPosArr.clear();
			for (int j = 0; j < 4; j++)
				for (int i = zoneL + 1; i <= zoneR - 1; i++)
					xPosArr.push_back(i);
			std::random_device rd;
			std::mt19937 gen(rd());
			std::shuffle(xPosArr.begin(), xPosArr.end(), gen);
			stateID = 24;
		}
		break;
	case 24://ֱ
		{
			for (int num = (zoneR - zoneL) / 8; num > 0; num--)
			{
				int nextX = xPosArr.back();
				xPosArr.pop_back();
				//ü
				auto am = std::make_shared<CS_AmElectricCircle>();
				am->x = nextX * 16.0f;
				am->y = (zoneU - 3) * 16.0f;
				gameFunc->SetEntity(shared_from_this(), am);
				if (xPosArr.empty())
					break;
			}
			action_timecounter = 30;
			stateID = 25;
		}
		break;
	case 25:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			if (xPosArr.empty())
			{
				action_timecounter = 120;
				stateID = 26;
			}
			else
			{
				stateID = 24;
			}
		}
		break;
	case 26://ȥһģʽ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 1;
		break;
	case 30://׼
		{
			auto weyeL = eyeL.lock();
			if (weyeL)
				weyeL->SetState(L"laser_eyes", weyeL->lr);
			auto weyeR = eyeR.lock();
			if (weyeR)
				weyeR->SetState(L"laser_eyes", weyeR->lr);
			action_timecounter = 96;
			stateID = 31;
		}
		break;
	case 31:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			//
			auto weyeL = eyeL.lock();
			if (weyeL)
			{
				float angle = 0;
				for (int i = 0; i < 4; i++)
				{
					auto laserL = std::make_shared<CS_AmLaser>();
					laserL->x = weyeL->x - 13;
					laserL->y = weyeL->y - 4;
					laserL->angle = angle;
					gameFunc->SetEntity(shared_from_this(), laserL);
					laserList.push_back(laserL);
					angle += 90;
				}
			}
			auto weyeR = eyeR.lock();
			if (weyeR)
			{
				float angle = 0;
				for (int i = 0; i < 4; i++)
				{
					auto laserR = std::make_shared<CS_AmLaser>();
					laserR->x = weyeR->x + 13;
					laserR->y = weyeR->y - 4;
					laserR->angle = angle;
					gameFunc->SetEntity(shared_from_this(), laserR);
					laserList.push_back(laserR);
					angle += 90;
				}
			}
			//ʼ׼
			stateID = 32;
			action_timecounter = 60;
		}
		break;
	case 32://򿪼
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			for (auto& e : laserList)
			{
				auto we = e.lock();
				if (we)
				{
					we->SetState(L"laser_on", we->lr);
				}
			}
			action_timecounter = 60;
			stateID = 33;
		}
		break;
	case 33://׼ʼת
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			int rotate_dir = Random(0, 1);
			for (auto& e : laserList)
			{
				auto we = e.lock();
				if (we)
				{
					we->rotate_speed = rotate_dir == 0 ? -1.0f : 1.0f;
				}
			}
			action_timecounter = 300;
			stateID = 34;
		}
		break;
	case 34://ֹͣ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			for (auto& e : laserList)
			{
				auto we = e.lock();
				if (we)
					we->Destroy();
			}
			//۾ָ֮ǰ״̬
			auto weyeL = eyeL.lock();
			if (weyeL)
				weyeL->SetState(L"close_eyes", weyeL->lr);
			auto weyeR = eyeR.lock();
			if (weyeR)
				weyeR->SetState(L"close_eyes", weyeR->lr);
			action_timecounter = 120;
			stateID = 35;
		}
		break;
	case 35:// ɢ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			empAttackCount = 3;
			stateID = 36;
		}
		break;
	case 36://
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			if (empAttackCount > 0)
			{
				empAttackCount--;
				stateID = 37;
			}
			else
			{
				action_timecounter = 120;
				stateID = 39;
			}
		}
		break;
	case 37:
		{
			int centerX = (zoneL + zoneR) / 2;
			int centerY = (zoneU + zoneD) / 2;
			auto am = std::make_shared<CS_AmEMP>();
			am->x = centerX * 16.0f;
			am->y = centerY * 16.0f;
			gameFunc->SetEntity(shared_from_this(), am);
			action_timecounter = 30;
			stateID = 38;
		}
		break;
	case 38:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			int centerX = (zoneL + zoneR) / 2;
			int centerY = (zoneU + zoneD) / 2;
			auto am = std::make_shared<CS_AmEMP>();
			am->x = centerX * 16.0f;
			am->y = centerY * 16.0f;
			gameFunc->SetEntity(shared_from_this(), am);
			action_timecounter = 120;
			stateID = 36;
		}
		break;
	case 39://ָ۾
		if(hp > 500)
		{
			auto weyeL = eyeL.lock();
			if (weyeL)
				weyeL->SetState(L"open_eyes", weyeL->lr);
			auto weyeR = eyeR.lock();
			if (weyeR)
				weyeR->SetState(L"open_eyes", weyeR->lr);
		}
		action_timecounter = 120;
		stateID = 40;
		break;
	case 40:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 1;
		break;
	case 100://ڶ׶
		action_timecounter = 60;
		stateID = 101;
		break;
	case 101:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			pawAttackCount = 12;//ù
			stateID = 102;
		}
		break;
	case 102:
		if (pawAttackCount > 0)
		{
			pawAttackCount--;
			if (pawAttackCount == 0)
			{
				//ù
				auto lr = 0;
				auto am = std::make_shared<CS_AmMonsterXPaw>(shared_from_this());
				am->y = (zoneD - 1) * 16.0f;
				am->x = zoneR * 16.0f;
				am->SetState(0, lr);
				gameFunc->SetEntity(shared_from_this(), am);
				lr = 1;
				am = std::make_shared<CS_AmMonsterXPaw>(shared_from_this());
				am->y = (zoneD - 1) * 16.0f;
				am->x = zoneL * 16.0f;
				am->SetState(0, lr);
				gameFunc->SetEntity(shared_from_this(), am);
			}
			else
			{
				//ù
				if (gameFunc->GetPlayerDistance)
				{
					auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
					if (wplayer)
					{
						//¹
						auto am = std::make_shared<CS_AmMonsterXPawD>(shared_from_this());
						am->y = (zoneU + 3) * 16.0f;
						am->x = std::clamp(wplayer->x + Random(-64, 64), (zoneL + 1) * 16.0f, (zoneR - 1) * 16.0f);
						am->SetState(L"angry_attack", am->lr);
						gameFunc->SetEntity(shared_from_this(), am);
					}
				}
			}
			action_timecounter = 20;
			stateID = 103;
		}
		else
		{
			//лĻĴ
			stateID = 104;
		}
		break;
	case 103:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 102;
		break;
	case 104://ĻĴ
		pawAttackCount = 40;//Ĵ
		stateID = 105;
		break;
	case 105:
		if (pawAttackCount > 0)
		{
			pawAttackCount--;
			if (pawAttackCount < 30)
			{
				//ù
				if (gameFunc->GetPlayerDistance)
				{
					auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
					if (wplayer)
					{
						//
						auto am = std::make_shared<CS_AmNekoPunch>(shared_from_this());
						if (wplayer->vx > 0)
							am->x = std::clamp(wplayer->x + Random(-16, 160), (zoneL + 1) * 16.0f, (zoneR - 1) * 16.0f);
						else
							am->x = std::clamp(wplayer->x + Random(-160, 16), (zoneL + 1) * 16.0f, (zoneR - 1) * 16.0f);
						am->y = std::clamp(wplayer->y + Random(-80, 80), (zoneU + 1) * 16.0f, (zoneD - 1) * 16.0f);
						am->lr = Random(0, 1);
						am->SetState(0, am->lr);
						gameFunc->SetEntity(shared_from_this(), am);
					}
				}
				action_timecounter = 5;
			}
			else
			{
				//ù
				if (gameFunc->GetPlayerDistance)
				{
					auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
					if (wplayer)
					{
						//
						auto am = std::make_shared<CS_AmNekoPunch>(shared_from_this());
						am->x = std::clamp(wplayer->x, (zoneL + 1) * 16.0f, (zoneR - 1) * 16.0f);
						am->y = std::clamp(wplayer->y, (zoneU + 1) * 16.0f, (zoneD - 1) * 16.0f);
						am->lr = Random(0, 1);
						am->SetState(0, am->lr);
						gameFunc->SetEntity(shared_from_this(), am);
					}
				}
				action_timecounter = 20;
			}
			stateID = 106;
		}
		else
		{
			//лè
			stateID = 107;
			action_timecounter = 60;
		}
		break;
	case 106:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 105;
		break;
	case 107://ȥһģʽ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 1;
		break;
	case 110://èй
		pawAttackCount = 3;
		stateID = 111;
		break;
	case 111://èй
		if (pawAttackCount > 0)
		{
			pawAttackCount--;
			//ù
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					auto am = std::make_shared<CS_AmSoundWaveBase>(shared_from_this());
					soundwaveList.push_back(am);
					am->x = std::clamp(wplayer->x, (zoneL + 6) * 16.0f, (zoneR - 6) * 16.0f);
					am->y = (zoneU - 1) * 16.0f;
					gameFunc->SetEntity(shared_from_this(), am);
					gameFunc->PlaySound(L"CS_Cat");
				}
			}
			action_timecounter = 120;
			stateID = 112;
		}
		else
		{
			action_timecounter = 120;
			stateID = 113;
		}
		break;
	case 112:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 111;
		break;
	case 113://ը
		pawAttackCount = 6;
		stateID = 114;
		break;
	case 114:
		if(pawAttackCount > 0)
		{
			pawAttackCount--;
			if (pawAttackCount == 0)
			{
				//ڶĿɵ
				std::set<int> xPosSet;
				while (xPosSet.size() < 4)
				{
					int i = Random(zoneL, zoneR);
					//ʹɼ
					if (xPosSet.find(i + 1) != xPosSet.end())
						continue;
					if (xPosSet.find(i - 1) != xPosSet.end())
						continue;
					xPosSet.insert(i);
				}
				for (auto& i : xPosSet)
				{
					auto am = std::make_shared<CS_AmFishMissileBig>(shared_from_this());
					fishMissileBigList.push_back(am);
					am->x = i * 16.0f;
					am->y = zoneU * 16.0f;
					am->lr = am->x > (zoneL + zoneR) * 16.0f / 2 ? 3 : 2;
					gameFunc->SetEntity(shared_from_this(), am);
					am->SetState(L"set_smog", am->lr);
				}
			}
			else
			{
				auto am = std::make_shared<CS_AmFishMissileBig>(shared_from_this());
				fishMissileBigList.push_back(am);
				am->x = Random(zoneL, zoneR) * 16.0f;
				am->y = zoneU * 16.0f;
				am->lr = am->x > (zoneL + zoneR) * 16.0f / 2 ? 3 : 2;
				gameFunc->SetEntity(shared_from_this(), am);
				am->SetState(L"set_smog", am->lr);
			}
			if (pawAttackCount > 1)
				action_timecounter = 60;
			else
				action_timecounter = 120;
			stateID = 115;
		}
		else
		{
			action_timecounter = 60;
			stateID = 116;
		}
		break;
	case 115:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 114;
		break;
	case 116:
		fishMissileBigList.remove_if([](auto& e)
		{
			return e.expired();
		});
		if (fishMissileBigList.empty())
		{
			action_timecounter = 60;
			stateID = 117;
		}
		break;
	case 117://ȥһģʽ
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
			stateID = 1;
		break;
	}
}

void CS_Boss_MonsterX::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
}


void CS_Boss_MonsterX::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"fight")
	{
		SetState(1, lr);
		//
		auto weyeL = eyeL.lock();
		if (weyeL)
		{
			weyeL->SetState(2, weyeL->lr);
			weyeL->SetState(L"show", weyeL->lr);
		}
		auto weyeR = eyeR.lock();
		if (weyeR)
		{
			weyeR->SetState(2, weyeR->lr);
			weyeR->SetState(L"show", weyeR->lr);
		}
	}
	else if (stateName == L"second_form")
	{
		//ڶ׶
		level = 1;
		attackModeList.clear();
		//׼ģʽ
		MonsterXAttackMode mode[] =
		{
			MonsterXAttackMode_ANGRY,
			MonsterXAttackMode_BOMB,
		};
		for (auto& p : mode)
			attackModeList.push_back(p);
		//
		auto weyeL = eyeL.lock();
		if (weyeL)
		{
			weyeL->SetState(2, weyeL->lr);
			weyeL->SetState(L"open_eyes", weyeL->lr);
		}
		auto weyeR = eyeR.lock();
		if (weyeR)
		{
			weyeR->SetState(2, weyeR->lr);
			weyeR->SetState(L"open_eyes", weyeR->lr);
		}
		stateID = 1;
	}
}

void CS_Boss_MonsterX::Destroy()
{
	auto weyeL = eyeL.lock();
	if (weyeL)
		weyeL->Destroy();
	auto weyeR = eyeR.lock();
	if (weyeR)
		weyeR->Destroy();
	for (auto& e : fishMissileList)
	{
		auto we = e.lock();
		if (we)
			we->Destroy();
	}
	for (auto& e : pawCoreList)
	{
		auto we = e.lock();
		if (we)
			we->Destroy();
	}
	for (auto& e : laserList)
	{
		auto we = e.lock();
		if (we)
			we->Destroy();
	}
	for (auto& e : soundwaveList)
	{
		auto we = e.lock();
		if (we)
			we->Destroy();
	}
	for (auto& e : fishMissileBigList)
	{
		auto we = e.lock();
		if (we)
			we->Destroy();
	}
	Entity::Destroy();
}

bool CS_Boss_MonsterX::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	switch (level)
	{
	case 0://300Ѫ
		if (hp > 500)
		{
			gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
			if (elemType == 0)
			{
				auto weyeL = eyeL.lock();
				if (weyeL)
					weyeL->shock_counter = 30;
			}
			else
			{
				auto weyeR = eyeR.lock();
				if (weyeR)
					weyeR->shock_counter = 30;
			}
			hp -= getDamage;
			*outRealDamage = getDamage;
			//ʾ˺ֵ
			if (gameFunc->dmgNum)
				gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
			if (hp <= 500)
			{
				bool bLaserEye = stateID >= 32 && stateID <= 34;
				if (!bLaserEye)
				{
					auto weyeL = eyeL.lock();
					if (weyeL)
						weyeL->SetState(L"close_eyes", weyeL->lr);
					auto weyeR = eyeR.lock();
					if (weyeR)
						weyeR->SetState(L"close_eyes", weyeR->lr);
				}
				if (gameFunc->StartEvent && screenShatteredEvent.length())
					gameFunc->StartEvent(gameFunc->gameScript, screenShatteredEvent.c_str(), L"tBoot");
			}
		}
		else
		{
			*outRealDamage = 0;
			return true;
		}
		break;
	case 1:
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
		if (elemType == 0)
		{
			auto weyeL = eyeL.lock();
			if (weyeL)
				weyeL->shock_counter = 30;
		}
		else
		{
			auto weyeR = eyeR.lock();
			if (weyeR)
				weyeR->shock_counter = 30;
		}
		hp -= getDamage;
		*outRealDamage = getDamage;
		//ʾ˺ֵ
		if (gameFunc->dmgNum)
			gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
		if (hp <= 0)
		{
			hp = 0;
			stateID = 0;
			auto weyeL = eyeL.lock();
			if (weyeL)
				weyeL->SetState(0, weyeL->lr);
			auto weyeR = eyeR.lock();
			if (weyeR)
				weyeR->SetState(0, weyeR->lr);
			for (auto& e : fishMissileList)
			{
				auto we = e.lock();
				if (we)
					we->Destroy();
			}
			for (auto& e : pawCoreList)
			{
				auto we = e.lock();
				if (we)
					we->Destroy();
			}
			for (auto& e : laserList)
			{
				auto we = e.lock();
				if (we)
					we->Destroy();
			}
			for (auto& e : soundwaveList)
			{
				auto we = e.lock();
				if (we)
					we->Destroy();
			}
			for (auto& e : fishMissileBigList)
			{
				auto we = e.lock();
				if (we)
					we->Destroy();
			}
		}
		break;
	}
	return true;
}

std::shared_ptr<Entity> CreateCS_Boss_MonsterX()
{
	return std::make_shared<CS_Boss_MonsterX>();
}
