#include "CS_Boss_DemonFlower.h"
#include "CS_PeSmoke.h"
#include "CS_AmDemonFlowerSeed.h"
CS_Boss_DemonFlower::CS_Boss_DemonFlower()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	float offX = 32;
	float offY = -80;
	cbRect.left = 32 - offX;
	cbRect.right = 48 + offX;
	cbRect.top = 32 - offY;
	cbRect.bottom = 32 + offY;
	ani.sprite_index = L"ls_demonflower_close";
	hp = 100;
	drawBeforeOtherEntity = true;
	ignoreCaught = true;
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(1);
}

void CS_Boss_DemonFlower::Step()
{
	if (hp == 0 && explodeCounter > 0)
	{
		if (explodeCounter % 8 == 0)
			gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
		explodeCounter--;
		SetCS_PeSmoke2(shared_from_this(), x, y);
		if (explodeCounter == 0)
		{
			gameFunc->PlaySound(L"CS_035_explosion1");
			ani.sprite_index = L"ls_demonflower_destroy";
		}
	}
	if (flash > 0)
		flash--;
	if (hp > 0 && stateID == 1)
	{
		//
		if (shootNum > 0)
		{
			if (shootInterval_counter % 3 == 0)
			{
				float radian = Random(285, 345) * deg2rad;
				float shootSpeed = Random(0x400, 0xc00) / ts;
				float shootVx = shootSpeed * cosf(radian);
				float shootVy = shootSpeed * sinf(radian);
				SetCS_AmDemonFlowerSeed(shared_from_this(),
					(float)Random((int)(x + 32 - 8), (int)(x + 32 + 8)),
					(float)Random((int)(y - 80 - 8), (int)(y - 80 + 8)),
					shootVx, shootVy);
				gameFunc->PlaySound(L"CS_039_em_fire");
				shootNum--;
			}
		}
		if (shootInterval_counter > 0)
			shootInterval_counter--;
		if (shootInterval_counter == 0)
		{
			shootInterval_counter = shootInterval_counter_max;
			shootNum = shootNum_max;
		}
		ani.sprite_index = flash > 0 ? L"ls_demonflower_hurt" : L"ls_demonflower_open";
	}
}

void CS_Boss_DemonFlower::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_demonflower_close" : L"ls_demonflower_destroy";
	if (lr != 0)
		type = 0;
}

void CS_Boss_DemonFlower::SetState(std::wstring stateName, int lr)
{
	this->lr = lr;
	if (stateName == L"close")
	{
		stateID = 0;
		gameFunc->PlaySound(L"CS_115_core_thrust");
		ani.sprite_index = L"ls_demonflower_close";
		for (size_t i = 0; i < 8; i++)
		{
			int offset_x = Random((int)-cbRect.left, (int)cbRect.right);
			int offset_y = Random((int)-cbRect.top, (int)cbRect.bottom);
			auto e = std::make_shared<CS_PeSmoke>();
			e->x = x + offset_x;
			e->y = y + offset_y;
			gameFunc->SetEntity(shared_from_this(), e);
		}
	}
	else if (stateName == L"open")
	{
		stateID = 1;
		gameFunc->PlaySound(L"CS_115_core_thrust");
		ani.sprite_index = L"ls_demonflower_open";
		for (size_t i = 0; i < 8; i++)
		{
			int offset_x = Random((int)-cbRect.left, (int)cbRect.right);
			int offset_y = Random((int)-cbRect.top, (int)cbRect.bottom);
			auto e = std::make_shared<CS_PeSmoke>();
			e->x = x + offset_x;
			e->y = y + offset_y;
			gameFunc->SetEntity(shared_from_this(), e);
		}
		shootInterval_counter = shootInterval_counter_max;
		shootNum = shootNum_max;
	}
	else if (stateName == L"defeated")
	{
		type = 0;
		explodeCounter = 100;
		hp = 0;
	}
	else if (stateName == L"secondState")
	{
		shootNum_max = 40;
		shootInterval_counter_max = 800;
	}
}

bool CS_Boss_DemonFlower::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (lr != 0)
		return false;
	if (stateID == 0)
	{
		*outRealDamage = 0;
		return true;
	}
	flash = 10;
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x + 48, y - 96, 0, shared_from_this());
	//˺תƵƺ
	auto wcontrolCore = controlCore.lock();
	if (wcontrolCore)
		return wcontrolCore->Hurt(src, getDamage, angle, bTakedown, elemType, shockForce, shockForce, outRealDamage);
	return true;
}

std::shared_ptr<Entity> CreateCS_Boss_DemonFlower()
{
	return std::make_shared<CS_Boss_DemonFlower>();
}
