#include "CS_BalrogAni.h"
#include "CS_PeSmoke.h"
CS_BalrogAni::CS_BalrogAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 14;
	cbRect.top = 15;
	cbRect.bottom = 8;
}

void CS_BalrogAni::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		ani_no = 0;
		[[fallthrough]];
	case 1:
		if (Random(0, 100) == 0)
		{
			act_no = 2;
			act_wait = 0;
			ani_no = 1;
		}
		break;
	case 2:
		if (++act_wait > 16)
		{
			act_no = 1;
			ani_no = 0;
		}
		break;
	case 10:
		act_no = 11;
		ani_no = 2;
		act_wait = 0;
		tgt_x = 0;
		[[fallthrough]];
	case 11:
		if (++act_wait > 30)
		{
			act_no = 12;
			act_wait = 0;
			ani_no = 3;
			vy = -0x800 / ts;
			cbRect.enableSoild = false;
		}
		break;
	case 12:
		if (y < 0)
		{
			code_char = 0;
			gameFunc->PlaySound(L"CS_026_quake");
			gameFunc->SetQuake(gameFunc->game, 30, 0);
		}
		break;
	case 20:
		act_no = 21;
		ani_no = 5;
		act_wait = 0;
		count1 = 0;
		for (int i = 0; i < 4; ++i)
		{
			auto pe = std::make_shared<CS_PeSmoke>();
			pe->x = x + (float)Random(-12, 12);
			pe->y = y + (float)Random(-12, 12);
			pe->vx = Random(-341, 341) / ts;
			pe->vy = Random(-0x600, 0) / ts;
			gameFunc->SetEntity(shared_from_this(), pe);
		}
		gameFunc->PlaySound(L"CS_072_big_crash");
		[[fallthrough]];
	case 21:
		tgt_x = 1;
		if (cbRect.cbBottom)
			++act_wait;
		if (++count1 / 2 % 2)
			x++;
		else
			x--;
		if (act_wait > 100)
		{
			act_no = 11;
			act_wait = 0;
			ani_no = 2;
		}
		vy += 0x20 / ts;
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		break;
	case 30:
		ani_no = 4;
		if (++act_wait > 100)
		{
			act_no = 0;
			ani_no = 0;
		}
		break;
	case 40:
		act_no = 41;
		act_wait = 0;
		ani_no = 5;
		[[fallthrough]];
	case 41:
		if (++ani_wait / 2 % 2)
			ani_no = 5;
		else
			ani_no = 6;
		break;
	case 42:
		act_no = 43;
		act_wait = 0;
		ani_no = 6;
		[[fallthrough]];
	case 43:
		if (++ani_wait / 2 % 2)
			ani_no = 7;
		else
			ani_no = 6;
		break;
	case 50:
		ani_no = 8;
		vx = 0;
		break;
	case 60:
		act_no = 61;
		ani_no = 9;
		ani_wait = 0;
		[[fallthrough]];
	case 61:
		if (++ani_wait > 3)
		{
			ani_wait = 0;
			if (++ani_no == 10 || ani_no == 11)
				gameFunc->PlaySound(L"CS_023_thud");
		}
		if (ani_no > 12)
			ani_no = 9;
		if (lr == 0)
			vx = -0x200 / ts;
		else
			vx = 0x200 / ts;
		break;
	case 80:
		count1 = 0;
		act_no = 81;
		[[fallthrough]];
	case 81:
		if (++count1 / 2 % 2)
			x++;
		else
			x--;
		ani_no = 5;
		vx = 0;
		vy += 0x20 / ts;
		break;
	}
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	ani.sprite_index = lr == 0 ? L"mc_balrog1_l" : L"mc_balrog1_r";
}

void CS_BalrogAni::SetState(int stateID, int lr)
{
	if (el.arg.length() > 0)
	{
		SetState(el.arg, lr);
		el.arg.clear();
	}
	this->lr = lr;
	switch (stateID)
	{
	case 0:
		vx = 0;
		break;
	}
	act_no = stateID;
	ani.sprite_index = lr == 0 ? L"mc_balrog1_l" : L"mc_balrog1_r";
}

void CS_BalrogAni::SetState(std::wstring stateName, int lr)
{
	if(stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(60, lr);
	else if (stateName == L"back")
		SetState(50, lr);
	else if (stateName == L"shock")
		SetState(80, lr);
	else if (stateName == L"happy")
		SetState(30, lr);
	else if (stateName == L"in_counter")
	{
		drawBeforeOtherEntity = true;
		y -= 2;
	}
	else if (stateName == L"leave_counter")
	{
		drawBeforeOtherEntity = false;
		y += 2;
	}
	else if (stateName == L"drawBefore")
	{
		drawBeforeOtherEntity = true;
	}
}

std::shared_ptr<Entity> CreateCS_BalrogAni()
{
	return std::make_shared<CS_BalrogAni>();
}
