#include "CS_AmFireWhirrr.h"
#include "CS_PePhoton.h"
#include "CS_PeSmoke.h"
CS_AmFireWhirrr::CS_AmFireWhirrr(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	lr = parent->lr;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 4;
	cbRect.bottom = cbRect.top = 12;
	hp_max = hp = 50;
	dropExp = 10;
	//ö
	ani.png = L"CS_CaveStoryMod";
	//
	speedDir = true;
}

void CS_AmFireWhirrr::Step()
{
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else
	{
		if (bHorizontal)
		{
			if ((cbRect.cbBottom && lr == 0) || (cbRect.cbTop && lr != 0))
			{
				SetCS_PePhoton(shared_from_this(), x, y);
				Destroy();
			}
		}
		else
		{
			if ((cbRect.cbLeft && lr == 0) || (cbRect.cbRight && lr != 0))
			{
				SetCS_PePhoton(shared_from_this(), x, y);
				Destroy();
			}
		}
	}
	if (bHorizontal)
		vy = lr == 0 ? 0x200 / ts : -0x200 / ts;
	else
		vx = lr == 0 ? -0x200 / ts : 0x200 / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
	//
	if (bHorizontal)
		ani.sprite_index = lr == 0 ? L"am_firewhirrr_d" : L"am_firewhirrr_u";
	else
		ani.sprite_index = lr == 0 ? L"am_firewhirrr_l" : L"am_firewhirrr_r";
}

void CS_AmFireWhirrr::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 5;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

void CS_AmFireWhirrr::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void SetCS_AmFireWhirrr(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy, bool bHorizontal)
{
	auto am = std::make_shared<CS_AmFireWhirrr>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	am->bHorizontal = bHorizontal;
	parent->gameFunc->SetEntity(parent, am);
}
