#include "CS_AmElectricCircleCore.h"
#include "CS_AmElectricCircle.h"
CS_AmElectricCircleCore::CS_AmElectricCircleCore(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
}

bool CS_AmElectricCircleCore::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		auto am = std::static_pointer_cast<CS_AmElectricCircle>(wattackParent);
		am->bHurtBlock = false;
		auto ret = am->Hurt(src, getDamage, angle, bTakedown, elemType, shockForce, heavy, outRealDamage);
		am->bHurtBlock = true;
		return ret;
	}
	return false;
}
