#include "CS_AmElectricCircle.h"
#include "CS_AmElectricCircleCore.h"
#include <algorithm>
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_AmElectricCircle::CS_AmElectricCircle()
{
    type = 2;
    hp_max = hp = 16;
    //ö
    ani.png = L"CS_CaveStoryMod";
    ani.sprite_index = L"am_electriccircle_core";
    action_timecounter = action_timecounter_max = 30;
    dropExp = 9;
    vy = 0x400 / ts;
    //
    noDir = true;
}

void CS_AmElectricCircle::Init(std::weak_ptr<Entity> self)
{
    auto wcore = std::make_shared<CS_AmElectricCircleCore>(shared_from_this());
    core = wcore;
    wcore->x = x;
    wcore->y = y;
    gameFunc->SetEntity(shared_from_this(), wcore);
    ActionEntity::Init(self);
}

void CS_AmElectricCircle::Step()
{
    if (existTime > 0)
        existTime--;
    if (existTime == 0)
    {
        bLeave = true;
        attackState = false;
    }
    alpha = (BYTE)(0xff * action_timecounter / action_timecounter_max);
    color = RGBA(0xff, 0xff, 0xff, alpha);
    //ùΧ
    cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = r;
	//Բİ뾶
    GenerateWavyCircle(0, 0, r, (int)(r * 2), 1, 1,16);
    DrawPolyline();
    if (bLeave && action_timecounter > 0)
    {
        action_timecounter--;
        if (action_timecounter == 0)
            Destroy();
    }
    //ִ˶
    Entity::Step();
    auto wcore = core.lock();
    if (wcore)
    {
        wcore->x = x;
        wcore->y = y;
    }
}

void CS_AmElectricCircle::Destroy()
{
    auto wcore = core.lock();
    if (wcore)
        wcore->Destroy();
    ActionEntity::Destroy();
}

bool CS_AmElectricCircle::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
    if (bHurtBlock)
        return false;
    if (getDamage == 0)
        return false;
    *outRealDamage = getDamage;
    hp -= getDamage;
    if (hp > 0)
    {
        gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
    }
    else
    {
        gameFunc->PlaySound(L"CS_071_little_crash");
        //
        SetCS_PeSmokeMedium(shared_from_this(), x, y);
        hp = 0;
        //Ʒ
        SetDropItem(shared_from_this(), x, y, dropExp);
        Destroy();
    }
    //ʾ˺ֵ
    if (gameFunc->dmgNum)
        gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
    return true;
}

void CS_AmElectricCircle::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 10;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

// ɲԲߵĵ㼯
void CS_AmElectricCircle::GenerateWavyCircle(
    float centerX, float centerY,  // Բ
    float radius,                  // 뾶
    int segments,                  // ֶ(ԽԽԲ)
    float waveAmplitude,           // 
    int waveFrequency,             // Ƶ()
    float noiseAmplitude)    // (ѡ)
{
    polyline.clear();

    for (int i = 0; i <= segments; ++i)
    {
        float angle = XM_2PI * i / segments;

        // Բϵĵ
        float baseX = centerX + radius * cos(angle);
        float baseY = centerY + radius * sin(angle);

        // ӲЧ
        float waveOffset = waveAmplitude * sin(angle * waveFrequency);

        // (ѡ)
        float noise = noiseAmplitude * (std::rand() % 100 / 100.0f - 0.5f);

        // յλ
        float finalRadius = radius + waveOffset + noise;
        CS_AmElectricCircle::Point p;
        p.x = centerX + finalRadius * cos(angle);
        p.y = centerY + finalRadius * sin(angle);

        polyline.push_back(p);
    }
}

// 
void CS_AmElectricCircle::DrawPolyline()
{
    if (polyline.size() < 2)
        return;
    fillList.clear();
    int index = 0;
    DWORD c = RGBA(0xff, 0, 0, alpha);
    for (size_t i = 0; i < polyline.size() - 1; ++i)
        index += AddFillLine(fillList, index, polyline[i].x, polyline[i].y, c, polyline[i + 1].x, polyline[i + 1].y, c, 1);
    //β
    index += AddFillLine(fillList, index, polyline.back().x, polyline.back().y, c, polyline.front().x, polyline.front().y, c, 1);
}

std::shared_ptr<Entity> CreateCS_AmElectricCircle()
{
	return std::make_shared<CS_AmElectricCircle>();
}
