#include "CS_ActionCopyAi.h"

void CS_ActionCopyAi::Init(std::weak_ptr<Entity> self)
{
	InitControlTarget();
	auto wicon = std::make_shared<CS_MyCharAi_Icon>();
	icon = wicon;
	gameFunc->SetEntity(shared_from_this(), wicon);
	Entity::Init(self);
}

void CS_ActionCopyAi::Step()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
	{
		Destroy();
		return;
	}
	CheckResetFollowTarget();
	auto followTarget = wattackParent->attackParent.lock();
	if (!followTarget)
	{
		followTarget = gameFunc->GetMyChar_Player1(gameFunc->entityRes).lock();
		return;
	}
	//
	shadowOpList.push_back(followTarget->input);
	if (shadowOpList.size() >= 20)
	{
		DWORD targetKey = shadowOpList.front().key;
		shadowOpList.pop_front();
		wattackParent->input.key &= GameInput::keybit_switchMc;
		//ȡһΪĲ
		const DWORD mask =
			GameInput::keybit_atk |
			GameInput::keybit_jump |
			GameInput::keybit_left |
			GameInput::keybit_right |
			GameInput::keybit_up |
			GameInput::keybit_down;
		wattackParent->input.key |= targetKey & mask;
	}
	//
	auto& gameflag = *gameFunc->flagSet;
	noDir = gameflag.find(L"InLift") == gameflag.end();//Ƿ

	MoveOp moveOp;
	moveOp.x = followTarget->x;
	moveOp.y = followTarget->y;
	if (moveOpList.empty())
	{
		initX = wattackParent->x;
		initY = wattackParent->y;
	}
	moveOpList.push_back(moveOp);
	if (moveOpList.size() >= 20)
	{
		if (noDir)
		{
			wattackParent->last_x = wattackParent->x;
			wattackParent->last_y = wattackParent->y;
			wattackParent->x = moveOpList.front().x;
			wattackParent->y = moveOpList.front().y;
		}
		moveOpList.pop_front();
	}
	else
	{
		wattackParent->last_x = wattackParent->x;
		wattackParent->last_y = wattackParent->y;

		wattackParent->x = lerp(initX, moveOpList.front().x, moveOpList.size() / 20.0f);
		wattackParent->y = lerp(initY, moveOpList.front().y, moveOpList.size() / 20.0f);
	}
	//Ŀɫ
	if (gameFunc->ScriptIsRunning)
	{
		if (!gameFunc->ScriptIsRunning(gameFunc->gameScript))
			wattackParent->color = wattackParent->color & RGBA(0xff, 0xff, 0xff, 0x80);
	}
	//aiͼ
	auto wicon = icon.lock();
	if (wicon)
	{
		wicon->x = wattackParent->x + wicon->dx;
		wicon->y = wattackParent->y - 16 + wicon->dy;
		wicon->last_x = wattackParent->last_x + wicon->dx;
		wicon->last_y = wattackParent->last_y - 16 + wicon->dy;
		//ͼ
		if (gameFunc->ScriptIsRunning)
		{
			if (gameFunc->ScriptIsRunning(gameFunc->gameScript))
				wicon->ani.sprite_index.clear();
			else
				wicon->ani.sprite_index = L"ai";
		}
		//
		if (wattackParent->hide)
		{
			wicon->ani.sprite_index.clear();
		}
	}
}

void CS_ActionCopyAi::Destroy()
{
	//ҵԼĿĿ꣬ȻƳ
	auto wattackParent = attackParent.lock();
	if (wattackParent)
		wattackParent->ai.reset();
	auto wicon = icon.lock();
	if (wicon)
		wicon->Destroy();
	Entity::Destroy();
}

void CS_ActionCopyAi::InitControlTarget()
{
	//Ѱҿƶ
	if (gameFunc->GetGlobalEntityTable)
	{
		auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
		for (auto& p : allPlayer)
		{
			auto we = p.second.lock();
			if (we)
			{
				auto wplayer = std::dynamic_pointer_cast<MyCharEntity>(we);
				if (wplayer)
				{
					if (wplayer->ai.expired())
						continue;
					if (wplayer->ai.lock() == shared_from_this())
					{
						attackParent = wplayer;
						//Ŀ
						if (wplayer->lastAI_followTarget.length())
						{
							for (auto& t : allPlayer)
							{
								auto wtarget = t.second.lock();
								if (wtarget)
								{
									if (wplayer->lastAI_followTarget == wtarget->globalEntityID)
									{
										wplayer->attackParent = wtarget;
										break;
									}
								}
							}
						}
						break;
					}
				}
			}
		}
	}
	if (attackParent.expired())
		Destroy();
}

void CS_ActionCopyAi::CheckResetFollowTarget()
{
	//AIԶ
	auto wcontrolTarget = attackParent.lock();
	if (!wcontrolTarget)
		return;

	std::shared_ptr<Entity> wfollowTarget = wcontrolTarget->attackParent.lock();
	if (wfollowTarget)
	{
		//鿴ǰǷ
		auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
		for (auto& p : allPlayer)
		{
			auto wplayer = p.second.lock();
			if (wplayer)
			{
				if (wplayer->hide)
					continue;
				if (wplayer == wcontrolTarget)
					continue;
				if (wplayer->enableAI &&
					wplayer->attackParent.lock() == wcontrolTarget &&
					wfollowTarget == wplayer)
				{
					//ֹ׻
					ResetFollowTarget();
					break;
				}
				if (wplayer->enableAI && wplayer->attackParent.lock() == wfollowTarget)
				{
					//·һ
					ResetFollowTarget();
					break;
				}
			}
		}
	}
	else
		ResetFollowTarget();
}

void CS_ActionCopyAi::ResetFollowTarget()
{
	//AIԶ
	auto wcontrolTarget = attackParent.lock();
	if (!wcontrolTarget)
		return;

	auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
	for (auto& p : allPlayer)
	{
		auto wdst = p.second.lock();
		//ѡһ
		if (wdst)
		{
			if (wdst->hide)
				continue;
			if (wdst->el.name == L"null")
				continue;
			if (wdst == wcontrolTarget)
				continue;
			//鿴ǰǷ
			bool bContinue = false;
			for (auto& t : allPlayer)
			{
				auto wsrc = t.second.lock();
				if (wsrc)
				{
					if (wsrc->hide)
						continue;
					if (wsrc == wdst)
						continue;
					if (wsrc->enableAI && wsrc->attackParent.lock() == wdst)
					{
						bContinue = true;
						break;
					}
				}
			}
			if (bContinue)
			{
				continue;
			}
			else
			{
				//
				wcontrolTarget->attackParent = wdst;
				break;
			}
		}
	}
}

std::shared_ptr<Entity> CreateCS_ActionCopyAi()
{
	return std::make_shared<CS_ActionCopyAi>();
}
